/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.integration;

import java.util.Optional;
import java.util.function.Function;
import org.neo4j.gds.applications.graphstorecatalog.CatalogBusinessFacade;
import org.neo4j.gds.applications.graphstorecatalog.CatalogConfigurationService;
import org.neo4j.gds.applications.graphstorecatalog.CypherProjectApplication;
import org.neo4j.gds.applications.graphstorecatalog.DropGraphApplication;
import org.neo4j.gds.applications.graphstorecatalog.DropNodePropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.DropRelationshipsApplication;
import org.neo4j.gds.applications.graphstorecatalog.EstimateCommonNeighbourAwareRandomWalkApplication;
import org.neo4j.gds.applications.graphstorecatalog.GenerateGraphApplication;
import org.neo4j.gds.applications.graphstorecatalog.GenericProjectApplication;
import org.neo4j.gds.applications.graphstorecatalog.GraphMemoryUsageApplication;
import org.neo4j.gds.applications.graphstorecatalog.GraphNameValidationService;
import org.neo4j.gds.applications.graphstorecatalog.GraphSamplingApplication;
import org.neo4j.gds.applications.graphstorecatalog.GraphStoreValidationService;
import org.neo4j.gds.applications.graphstorecatalog.ListGraphApplication;
import org.neo4j.gds.applications.graphstorecatalog.NativeProjectApplication;
import org.neo4j.gds.applications.graphstorecatalog.NodeLabelMutatorApplication;
import org.neo4j.gds.applications.graphstorecatalog.StreamNodePropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.StreamRelationshipPropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.StreamRelationshipsApplication;
import org.neo4j.gds.applications.graphstorecatalog.SubGraphProjectApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteNodeLabelApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteNodePropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteRelationshipPropertiesApplication;
import org.neo4j.gds.applications.graphstorecatalog.WriteRelationshipsApplication;
import org.neo4j.gds.beta.filter.GraphStoreFilterService;
import org.neo4j.gds.core.loading.GraphStoreCatalogService;
import org.neo4j.gds.legacycypherprojection.GraphProjectCypherResult;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.metrics.projections.ProjectionMetricsService;
import org.neo4j.gds.procedures.KernelTransactionAccessor;
import org.neo4j.gds.procedures.ProcedureTransactionAccessor;
import org.neo4j.gds.procedures.TaskRegistryFactoryService;
import org.neo4j.gds.procedures.TerminationFlagService;
import org.neo4j.gds.procedures.TransactionContextAccessor;
import org.neo4j.gds.procedures.integration.CatalogFacadeProvider;
import org.neo4j.gds.procedures.integration.ExporterBuildersProviderService;
import org.neo4j.gds.projection.GraphProjectNativeResult;
import org.neo4j.gds.services.DatabaseIdAccessor;
import org.neo4j.gds.services.UserAccessor;
import org.neo4j.gds.services.UserLogServices;

class CatalogFacadeProviderFactory {
    private final Log log;
    private final ExporterBuildersProviderService exporterBuildersProviderService;
    private final Optional<Function<CatalogBusinessFacade, CatalogBusinessFacade>> businessFacadeDecorator;

    CatalogFacadeProviderFactory(Log log, ExporterBuildersProviderService exporterBuildersProviderService, Optional<Function<CatalogBusinessFacade, CatalogBusinessFacade>> businessFacadeDecorator) {
        this.log = log;
        this.exporterBuildersProviderService = exporterBuildersProviderService;
        this.businessFacadeDecorator = businessFacadeDecorator;
    }

    CatalogFacadeProvider createCatalogFacadeProvider(GraphStoreCatalogService graphStoreCatalogService, DatabaseIdAccessor databaseIdAccessor, KernelTransactionAccessor kernelTransactionAccessor, TaskRegistryFactoryService taskRegistryFactoryService, ProjectionMetricsService projectionMetricsService, TerminationFlagService terminationFlagService, UserLogServices userLogServices, UserAccessor userServices) {
        CatalogConfigurationService catalogConfigurationService = new CatalogConfigurationService();
        GraphNameValidationService graphNameValidationService = new GraphNameValidationService();
        GraphStoreFilterService graphStoreFilterService = new GraphStoreFilterService();
        GraphStoreValidationService graphStoreValidationService = new GraphStoreValidationService();
        ProcedureTransactionAccessor procedureTransactionAccessor = new ProcedureTransactionAccessor();
        TransactionContextAccessor transactionContextAccessor = new TransactionContextAccessor();
        CypherProjectApplication cypherProjectApplication = new CypherProjectApplication(new GenericProjectApplication(this.log, graphStoreCatalogService, GraphProjectCypherResult.Builder::new));
        DropGraphApplication dropGraphApplication = new DropGraphApplication(graphStoreCatalogService);
        DropNodePropertiesApplication dropNodePropertiesApplication = new DropNodePropertiesApplication(this.log);
        DropRelationshipsApplication dropRelationshipsApplication = new DropRelationshipsApplication(this.log);
        EstimateCommonNeighbourAwareRandomWalkApplication estimateCommonNeighbourAwareRandomWalkApplication = new EstimateCommonNeighbourAwareRandomWalkApplication();
        GenerateGraphApplication generateGraphApplication = new GenerateGraphApplication(this.log, graphStoreCatalogService);
        GraphMemoryUsageApplication graphMemoryUsageApplication = new GraphMemoryUsageApplication(graphStoreCatalogService);
        GraphSamplingApplication graphSamplingApplication = new GraphSamplingApplication(this.log, graphStoreCatalogService);
        ListGraphApplication listGraphApplication = ListGraphApplication.create((GraphStoreCatalogService)graphStoreCatalogService);
        NativeProjectApplication nativeProjectApplication = new NativeProjectApplication(new GenericProjectApplication(this.log, graphStoreCatalogService, GraphProjectNativeResult.Builder::new));
        NodeLabelMutatorApplication nodeLabelMutatorApplication = new NodeLabelMutatorApplication();
        StreamNodePropertiesApplication streamNodePropertiesApplication = new StreamNodePropertiesApplication(this.log);
        StreamRelationshipPropertiesApplication streamRelationshipPropertiesApplication = new StreamRelationshipPropertiesApplication(this.log);
        StreamRelationshipsApplication streamRelationshipsApplication = new StreamRelationshipsApplication();
        SubGraphProjectApplication subGraphProjectApplication = new SubGraphProjectApplication(this.log, graphStoreFilterService, graphStoreCatalogService);
        WriteNodeLabelApplication writeNodeLabelApplication = new WriteNodeLabelApplication(this.log);
        WriteNodePropertiesApplication writeNodePropertiesApplication = new WriteNodePropertiesApplication(this.log);
        WriteRelationshipPropertiesApplication writeRelationshipPropertiesApplication = new WriteRelationshipPropertiesApplication(this.log);
        WriteRelationshipsApplication writeRelationshipsApplication = new WriteRelationshipsApplication(this.log);
        return new CatalogFacadeProvider(catalogConfigurationService, this.log, graphNameValidationService, graphStoreCatalogService, graphStoreValidationService, procedureTransactionAccessor, databaseIdAccessor, this.exporterBuildersProviderService, kernelTransactionAccessor, taskRegistryFactoryService, terminationFlagService, transactionContextAccessor, userLogServices, userServices, cypherProjectApplication, dropGraphApplication, dropNodePropertiesApplication, dropRelationshipsApplication, estimateCommonNeighbourAwareRandomWalkApplication, generateGraphApplication, graphMemoryUsageApplication, graphSamplingApplication, listGraphApplication, nativeProjectApplication, nodeLabelMutatorApplication, streamNodePropertiesApplication, streamRelationshipPropertiesApplication, streamRelationshipsApplication, subGraphProjectApplication, writeNodeLabelApplication, writeNodePropertiesApplication, writeRelationshipPropertiesApplication, writeRelationshipsApplication, this.businessFacadeDecorator, projectionMetricsService);
    }
}

