/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.integration;

import org.neo4j.function.ThrowingFunction;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.metrics.procedures.DeprecatedProceduresMetricService;
import org.neo4j.gds.procedures.GraphDataScience;
import org.neo4j.gds.procedures.catalog.CatalogFacade;
import org.neo4j.gds.procedures.centrality.CentralityProcedureFacade;
import org.neo4j.gds.procedures.community.CommunityProcedureFacade;
import org.neo4j.gds.procedures.embeddings.NodeEmbeddingsProcedureFacade;
import org.neo4j.gds.procedures.integration.AlgorithmFacadeProviderFactory;
import org.neo4j.gds.procedures.integration.AlgorithmProcedureFacadeProvider;
import org.neo4j.gds.procedures.integration.CatalogFacadeProvider;
import org.neo4j.gds.procedures.pathfinding.PathFindingProcedureFacade;
import org.neo4j.gds.procedures.similarity.SimilarityProcedureFacade;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.procedure.Context;

public class GraphDataScienceProvider
implements ThrowingFunction<Context, GraphDataScience, ProcedureException> {
    private final Log log;
    private final CatalogFacadeProvider catalogFacadeProvider;
    private final AlgorithmFacadeProviderFactory algorithmFacadeService;
    private final DeprecatedProceduresMetricService deprecatedProceduresMetricService;

    GraphDataScienceProvider(Log log, CatalogFacadeProvider catalogFacadeProvider, AlgorithmFacadeProviderFactory algorithmFacadeService, DeprecatedProceduresMetricService deprecatedProceduresMetricService) {
        this.log = log;
        this.catalogFacadeProvider = catalogFacadeProvider;
        this.algorithmFacadeService = algorithmFacadeService;
        this.deprecatedProceduresMetricService = deprecatedProceduresMetricService;
    }

    public GraphDataScience apply(Context context) throws ProcedureException {
        CatalogFacade catalogFacade = this.catalogFacadeProvider.createCatalogFacade(context);
        context.dependencyResolver().resolveDependency(GraphDatabaseService.class);
        AlgorithmProcedureFacadeProvider algorithmFacadeProvider = this.algorithmFacadeService.createAlgorithmFacadeProvider(context);
        CentralityProcedureFacade centralityProcedureFacade = algorithmFacadeProvider.createCentralityProcedureFacade();
        CommunityProcedureFacade communityProcedureFacade = algorithmFacadeProvider.createCommunityProcedureFacade();
        PathFindingProcedureFacade pathFindingProcedureFacade = algorithmFacadeProvider.createPathFindingProcedureFacade();
        SimilarityProcedureFacade similarityProcedureFacade = algorithmFacadeProvider.createSimilarityProcedureFacade();
        NodeEmbeddingsProcedureFacade nodeEmbeddingsProcedureFacade = algorithmFacadeProvider.createNodeEmbeddingsProcedureFacade();
        return new GraphDataScience(this.log, catalogFacade, centralityProcedureFacade, communityProcedureFacade, nodeEmbeddingsProcedureFacade, similarityProcedureFacade, pathFindingProcedureFacade, this.deprecatedProceduresMetricService);
    }
}

