/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.Arrays;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.internal.recordstorage.InMemoryNodeScan;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.token.TokenHolders;

public abstract class AbstractInMemoryNodeCursor
extends NodeRecord
implements StorageNodeCursor {
    private long next;
    private long highMark;
    private final GraphStore graphStore;
    private final TokenHolders tokenHolders;
    private final boolean hasProperties;
    private final long[] nodeLabelReadBuffer;
    private final MutableInt nodeLabelCounter;

    public AbstractInMemoryNodeCursor(GraphStore graphStore, TokenHolders tokenHolders) {
        super(-1L);
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        this.hasProperties = !graphStore.nodePropertyKeys().isEmpty();
        this.nodeLabelReadBuffer = new long[graphStore.nodeLabels().size()];
        this.nodeLabelCounter = new MutableInt();
    }

    public abstract void properties(StoragePropertyCursor var1);

    public long[] labels() {
        this.nodeLabelCounter.setValue(0);
        this.graphStore.nodes().forEachNodeLabel(this.getId(), nodeLabel -> {
            this.nodeLabelReadBuffer[this.nodeLabelCounter.getAndIncrement()] = this.tokenHolders.labelTokens().getIdByName(nodeLabel.name());
            return true;
        });
        return Arrays.copyOf(this.nodeLabelReadBuffer, (int)this.nodeLabelCounter.getValue());
    }

    public boolean hasAtLeastOneLabelForCurrentNode() {
        MutableBoolean hasLabel = new MutableBoolean(false);
        this.graphStore.nodes().forEachNodeLabel(this.getId(), __ -> {
            hasLabel.setTrue();
            return false;
        });
        return hasLabel.booleanValue();
    }

    public boolean hasLabel(int labelId) {
        NodeLabel nodeLabel = NodeLabel.of((String)this.tokenHolders.labelGetName(labelId));
        return this.graphStore.nodes().hasLabel(this.getId(), nodeLabel);
    }

    public long relationshipsReference() {
        return this.getId();
    }

    public void relationships(StorageRelationshipTraversalCursor traversalCursor, RelationshipSelection selection) {
        traversalCursor.init(this.getId(), -1L, selection);
    }

    public int[] relationshipTypes() {
        return new int[0];
    }

    public boolean supportsFastDegreeLookup() {
        return false;
    }

    public void scan() {
        if (this.getId() != -1L) {
            this.resetState();
        }
        this.setId(0L);
        this.highMark = this.nodeHighMark();
    }

    public void single(long reference) {
        if (this.getId() != -1L) {
            this.resetState();
        }
        this.next = reference;
        this.highMark = reference;
    }

    public boolean scanBatch(AllNodeScan scan, int sizeHint) {
        if (this.getId() != -1L) {
            this.reset();
        }
        return ((InMemoryNodeScan)scan).scanBatch(sizeHint, this);
    }

    public boolean scanRange(long start, long stop) {
        long max = this.nodeHighMark();
        if (start > max) {
            this.reset();
            return false;
        }
        if (start > stop) {
            this.reset();
            return true;
        }
        this.next = start;
        this.highMark = Math.min(stop, max);
        return true;
    }

    public boolean hasProperties() {
        return this.hasProperties;
    }

    public long entityReference() {
        return this.getId();
    }

    public boolean next() {
        if (this.next == -1L) {
            this.resetState();
            return false;
        }
        this.setId(this.next);
        this.node(this, this.getId());
        ++this.next;
        if (this.next > this.highMark) {
            this.next = -1L;
        }
        return true;
    }

    public void reset() {
        this.resetState();
    }

    private void resetState() {
        this.setId(-1L);
        this.next = -1L;
        this.highMark = -1L;
        this.clear();
    }

    public void setForceLoad() {
    }

    public void close() {
    }

    private long nodeHighMark() {
        return this.graphStore.nodeCount() - 1L;
    }

    private void node(NodeRecord record, long nodeId) {
        record.setId(nodeId);
    }
}

