/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.ArrayUtil;
import org.neo4j.gds.compat.AbstractInMemoryPropertyCursor;
import org.neo4j.gds.compat.InMemoryPropertySelection;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public abstract class AbstractInMemoryNodePropertyCursor
extends AbstractInMemoryPropertyCursor.DelegatePropertyCursor {
    private final int[] nodePropertyKeyMapping;
    private final Value[] nodePropertyValues;
    private final CypherGraphStore graphStore;
    private final TokenHolders tokenHolders;
    private final Map<Integer, ValueGroup> propertyKeyToValueGroupMapping;
    private int nodePropertyCount;
    private int currentNodeProperty;

    public AbstractInMemoryNodePropertyCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        super(-1L);
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        int propertyCount = graphStore.nodePropertyKeys().size();
        this.nodePropertyKeyMapping = new int[propertyCount];
        this.nodePropertyValues = new Value[propertyCount];
        this.nodePropertyCount = 0;
        this.currentNodeProperty = -1;
        this.propertyKeyToValueGroupMapping = new HashMap<Integer, ValueGroup>();
        this.populateKeyToValueGroupMapping();
    }

    public int propertyKey() {
        if (this.currentNodeProperty >= 0) {
            return this.nodePropertyKeyMapping[this.currentNodeProperty];
        }
        throw new IllegalStateException("Property cursor is initialized as node and relationship cursor, maybe you forgot to `reset()`?");
    }

    protected void setPropertySelection(InMemoryPropertySelection propertySelection) {
        long nodeId = this.getId();
        this.nodePropertyCount = 0;
        this.graphStore.nodes().forEachNodeLabel(nodeId, label -> {
            for (String nodePropertyKey : this.graphStore.nodePropertyKeys(label)) {
                int propertyId = this.tokenHolders.propertyKeyTokens().getIdByName(nodePropertyKey);
                if (!propertySelection.test(propertyId) || ArrayUtil.linearSearch((int[])this.nodePropertyKeyMapping, (int)this.nodePropertyKeyMapping.length, (int)propertyId)) continue;
                ++this.nodePropertyCount;
                this.nodePropertyKeyMapping[propertyIndex] = propertyId;
                if (!propertySelection.isKeysOnly()) {
                    this.nodePropertyValues[propertyIndex] = ((NodePropertyValues)this.graphStore.nodeProperty(nodePropertyKey).values()).value(nodeId);
                }
                if (!propertySelection.isLimited() || this.nodePropertyCount != propertySelection.numberOfKeys()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean next() {
        if (this.getId() != -1L) {
            ++this.currentNodeProperty;
            return this.currentNodeProperty < this.nodePropertyCount;
        }
        return false;
    }

    public Value propertyValue() {
        if (this.currentNodeProperty >= 0) {
            return this.nodePropertyValues[this.currentNodeProperty];
        }
        throw new IllegalStateException("Property cursor is initialized as node and relationship cursor, maybe you forgot to `reset()`?");
    }

    public void reset() {
        this.clear();
        this.setId(-1L);
        this.nodePropertyCount = 0;
        this.currentNodeProperty = -1;
        Arrays.fill(this.nodePropertyKeyMapping, -1);
    }

    public void setForceLoad() {
    }

    public void close() {
    }

    public ValueGroup propertyType() {
        return this.propertyKeyToValueGroupMapping.get(this.propertyKey());
    }

    private void populateKeyToValueGroupMapping() {
        this.graphStore.schema().nodeSchema().unionProperties().forEach((propertyKey, propertySchema) -> this.propertyKeyToValueGroupMapping.put(this.tokenHolders.propertyKeyTokens().getIdByName(propertyKey), AbstractInMemoryNodePropertyCursor.valueGroupFromValueType(propertySchema.valueType())));
    }

    private static ValueGroup valueGroupFromValueType(ValueType valueType) {
        switch (valueType) {
            case DOUBLE: 
            case LONG: {
                return ValueGroup.NUMBER;
            }
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: 
            case FLOAT_ARRAY: {
                return ValueGroup.NUMBER_ARRAY;
            }
        }
        return ValueGroup.UNKNOWN;
    }
}

