/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import org.eclipse.collections.api.list.primitive.DoubleList;
import org.neo4j.gds.compat.AbstractInMemoryPropertyCursor;
import org.neo4j.gds.compat.InMemoryPropertySelection;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class AbstractInMemoryRelationshipPropertyCursor
extends AbstractInMemoryPropertyCursor.DelegatePropertyCursor {
    protected final CypherGraphStore graphStore;
    protected final TokenHolders tokenHolders;
    protected InMemoryPropertySelection selection;
    private DoubleList propertyValues;
    private int[] propertyIds;
    private int index;

    protected AbstractInMemoryRelationshipPropertyCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        super(-1L);
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        this.reset();
    }

    public void initRelationshipPropertyCursor(long id, int[] propertyIds, DoubleList propertyValues, InMemoryPropertySelection selection) {
        this.setId(id);
        this.setRelId(id);
        this.index = -1;
        this.propertyIds = propertyIds;
        this.propertyValues = propertyValues;
        this.selection = selection;
    }

    public boolean next() {
        if (this.getRelId() == -1L) {
            throw new IllegalStateException("Property cursor is not initialized.");
        }
        do {
            ++this.index;
            if (this.index < this.propertyIds.length) continue;
            return false;
        } while (!this.selection.test(this.propertyIds[this.index]));
        return true;
    }

    public int propertyKey() {
        if (this.getRelId() != -1L && this.index < this.propertyIds.length) {
            return this.propertyIds[this.index];
        }
        throw new IllegalStateException("Property cursor is not initialized.");
    }

    public ValueGroup propertyType() {
        return ValueGroup.NUMBER;
    }

    public Value propertyValue() {
        if (this.getRelId() != -1L && this.index < this.propertyIds.length) {
            return Values.doubleValue((double)this.propertyValues.get(this.index));
        }
        throw new IllegalStateException("Property cursor is not initialized.");
    }

    public void reset() {
        this.index = -1;
        this.propertyIds = null;
        this.propertyValues = null;
        this.setId(-1L);
        this.setRelId(-1L);
    }

    public void setForceLoad() {
    }

    public void close() {
    }
}

