/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.storageengine.InMemoryRelationshipCursor;
import org.neo4j.internal.recordstorage.BaseRecordScan;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.token.TokenHolders;

public abstract class AbstractInMemoryRelationshipScanCursor
extends InMemoryRelationshipCursor
implements StorageRelationshipScanCursor {
    private long highMark;

    public AbstractInMemoryRelationshipScanCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        super(graphStore, tokenHolders);
    }

    public void scan() {
        this.reset();
        this.sourceId = 0L;
        this.selection = RelationshipSelection.ALL_RELATIONSHIPS;
        this.highMark = this.maxRelationshipId;
    }

    public void single(long reference) {
        this.reset();
        this.setId(reference - 1L);
        this.highMark = reference;
        this.selection = RelationshipSelection.ALL_RELATIONSHIPS;
        this.initializeForRelationshipReference(reference);
    }

    @Override
    public boolean next() {
        if (super.next()) {
            return this.getId() <= this.highMark;
        }
        ++this.sourceId;
        if (this.sourceId >= this.graphStore.nodeCount()) {
            return false;
        }
        this.resetCursors();
        return this.next();
    }

    public boolean scanBatch(AllRelationshipsScan scan, int sizeHint) {
        if (this.getId() != -1L) {
            this.reset();
        }
        this.highMark = this.maxRelationshipId;
        return ((BaseRecordScan)scan).scanBatch(sizeHint, (PrimitiveRecord)this);
    }

    public boolean scanRange(long start, long stop) {
        this.reset();
        this.selection = RelationshipSelection.ALL_RELATIONSHIPS;
        this.highMark = Math.min(stop, this.maxRelationshipId);
        if (start > this.maxRelationshipId) {
            return false;
        }
        this.initializeForRelationshipReference(start);
        return true;
    }
}

