/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public abstract class AbstractTransactionIdStore
implements TransactionIdStore {
    protected final AtomicLong committingTransactionId = new AtomicLong();
    protected final OutOfOrderSequence closedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100, new long[5]);
    protected final AtomicReference<TransactionId> committedTransactionId = new AtomicReference<TransactionId>(this.transactionId(1L, -559063315, 0L));
    protected final long previouslyCommittedTxId;
    protected final int initialTransactionChecksum;
    protected final long previouslyCommittedTxCommitTimestamp;

    public AbstractTransactionIdStore() {
        this(1L, -559063315, 0L, 0L, 64L);
    }

    public AbstractTransactionIdStore(long previouslyCommittedTxId, int checksum, long previouslyCommittedTxCommitTimestamp, long previouslyCommittedTxLogVersion, long previouslyCommittedTxLogByteOffset) {
        assert (previouslyCommittedTxId >= 1L) : "cannot start from a tx id less than BASE_TX_ID";
        this.initLastCommittedAndClosedTransactionId(previouslyCommittedTxId, checksum, previouslyCommittedTxCommitTimestamp, previouslyCommittedTxLogVersion, previouslyCommittedTxLogByteOffset);
        this.previouslyCommittedTxId = previouslyCommittedTxId;
        this.initialTransactionChecksum = checksum;
        this.previouslyCommittedTxCommitTimestamp = previouslyCommittedTxCommitTimestamp;
    }

    protected abstract void initLastCommittedAndClosedTransactionId(long var1, int var3, long var4, long var6, long var8);

    protected abstract TransactionId transactionId(long var1, int var3, long var4);

    public long nextCommittingTransactionId() {
        return this.committingTransactionId.incrementAndGet();
    }

    public long committingTransactionId() {
        return this.committingTransactionId.get();
    }

    public long getLastCommittedTransactionId() {
        return this.committedTransactionId.get().transactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.committedTransactionId.get();
    }

    public long getLastClosedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber();
    }
}

