/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.Locale;
import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.gds.compat.AbstractInMemoryNodeCursor;
import org.neo4j.gds.compat.AbstractInMemoryNodePropertyCursor;
import org.neo4j.gds.compat.AbstractInMemoryRelationshipPropertyCursor;
import org.neo4j.gds.compat.AbstractInMemoryRelationshipTraversalCursor;
import org.neo4j.gds.compat.GdsDatabaseManagementServiceBuilder;
import org.neo4j.gds.compat.Neo4jVersion;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.recordstorage.AbstractInMemoryRelationshipScanCursor;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.token.TokenHolders;

public interface StorageEngineProxyApi {
    public static void requireNeo4jVersion(Neo4jVersion version, Class<?> self) {
        if (Neo4jVersion.findNeo4jVersion() != version) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "This '%s' instance is only compatible with Neo4j version %s, but Neo4j version %s has been detected.", self.getName(), version, Neo4jVersion.findNeo4jVersion()));
        }
    }

    public CommandCreationContext inMemoryCommandCreationContext();

    public void initRelationshipTraversalCursorForRelType(StorageRelationshipTraversalCursor var1, long var2, int var4);

    public StorageReader inMemoryStorageReader(CypherGraphStore var1, TokenHolders var2, CountsAccessor var3);

    public void createInMemoryDatabase(DatabaseManagementService var1, String var2, Config var3);

    public StorageEngine createInMemoryStorageEngine(DatabaseLayout var1, TokenHolders var2);

    public GraphDatabaseService startAndGetInMemoryDatabase(DatabaseManagementService var1, String var2);

    public GdsDatabaseManagementServiceBuilder setSkipDefaultIndexesOnCreationSetting(GdsDatabaseManagementServiceBuilder var1);

    public AbstractInMemoryNodeCursor inMemoryNodeCursor(CypherGraphStore var1, TokenHolders var2);

    public AbstractInMemoryNodePropertyCursor inMemoryNodePropertyCursor(CypherGraphStore var1, TokenHolders var2);

    public AbstractInMemoryRelationshipTraversalCursor inMemoryRelationshipTraversalCursor(CypherGraphStore var1, TokenHolders var2);

    public AbstractInMemoryRelationshipPropertyCursor inMemoryRelationshipPropertyCursor(CypherGraphStore var1, TokenHolders var2);

    public AbstractInMemoryRelationshipScanCursor inMemoryRelationshipScanCursor(CypherGraphStore var1, TokenHolders var2);

    public void properties(StorageEntityCursor var1, StoragePropertyCursor var2, int[] var3);

    public Edition dbmsEdition(GraphDatabaseService var1);
}

