/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.HashSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.storageengine.InMemoryTransactionStateVisitor;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;

public class TokenManager
implements CypherGraphStore.StateVisitor {
    private final TokenHolders tokenHolders;
    private final InMemoryTransactionStateVisitor transactionStateVisitor;
    private final CypherGraphStore graphStore;
    private final CommandCreationContext commandCreationContext;

    public TokenManager(TokenHolders tokenHolders, InMemoryTransactionStateVisitor transactionStateVisitor, CypherGraphStore graphStore, CommandCreationContext commandCreationContext) {
        this.tokenHolders = tokenHolders;
        this.transactionStateVisitor = transactionStateVisitor;
        this.graphStore = graphStore;
        this.commandCreationContext = commandCreationContext;
        this.init();
    }

    public void init() {
        this.initializeTokensFromGraphStore();
        this.graphStore.registerStateVisitor((CypherGraphStore.StateVisitor)this);
    }

    public void nodePropertyRemoved(String propertyKey) {
        this.transactionStateVisitor.removeNodeProperty(propertyKey);
    }

    public void nodePropertyAdded(String propertyKey) {
        this.getOrCreatePropertyToken(propertyKey);
    }

    public void nodeLabelAdded(String nodeLabel) {
        try {
            this.tokenHolders.labelTokens().getOrCreateId(nodeLabel);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    public void relationshipTypeAdded(String relationshipType) {
        try {
            this.tokenHolders.relationshipTypeTokens().getOrCreateId(relationshipType);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    public void relationshipPropertyAdded(String relationshipProperty) {
        this.getOrCreatePropertyToken(relationshipProperty);
    }

    private void getOrCreatePropertyToken(String propertyKey) {
        try {
            this.tokenHolders.propertyKeyTokens().getOrCreateId(propertyKey);
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenHolders tokenHolders() {
        return this.tokenHolders;
    }

    private void initializeTokensFromGraphStore() {
        HashSet propertyKeys = new HashSet(this.graphStore.nodePropertyKeys());
        propertyKeys.addAll(this.graphStore.relationshipPropertyKeys());
        propertyKeys.forEach(propertyKey -> this.tokenHolders.propertyKeyTokens().addToken(new NamedToken(propertyKey, this.commandCreationContext.reservePropertyKeyTokenId())));
        this.graphStore.nodeLabels().forEach(nodeLabel -> this.tokenHolders.labelTokens().addToken(new NamedToken(nodeLabel.name(), this.commandCreationContext.reserveLabelTokenId())));
        this.graphStore.relationshipTypes().forEach(relType -> this.tokenHolders.relationshipTypeTokens().addToken(new NamedToken(relType.name(), this.commandCreationContext.reserveRelationshipTypeTokenId())));
    }
}

