/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.storageengine;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.utils.StringFormatting;

public final class InMemoryDatabaseCreationCatalog {
    private static final Map<String, String> CATALOG = new ConcurrentHashMap<String, String>();

    private InMemoryDatabaseCreationCatalog() {
    }

    public static void registerDbCreation(String databaseName, String graphName) {
        String normalizedDatabaseName = Neo4jProxy.validateExternalDatabaseName((String)databaseName);
        if (CATALOG.containsKey(normalizedDatabaseName)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"An entry with key `%s` already exists", (Object[])new Object[]{databaseName}));
        }
        CATALOG.put(normalizedDatabaseName, graphName);
    }

    public static String getRegisteredDbCreationGraphName(String databaseName) {
        return CATALOG.get(Neo4jProxy.validateExternalDatabaseName((String)databaseName));
    }

    public static void removeDatabaseEntry(String databaseName) {
        String normalizedDatabaseName = Neo4jProxy.validateExternalDatabaseName((String)databaseName);
        CATALOG.remove(normalizedDatabaseName);
    }

    public static void removeAllRegisteredDbCreations() {
        CATALOG.clear();
    }

    public static Set<String> databaseNamesRegisteredForCreation() {
        return CATALOG.keySet();
    }
}

