/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.storageengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.PropertyCursor;
import org.neo4j.gds.compat.AbstractInMemoryRelationshipPropertyCursor;
import org.neo4j.gds.compat.InMemoryPropertySelection;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.core.cypher.RelationshipIds;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.token.TokenHolders;

public abstract class InMemoryRelationshipCursor
extends RelationshipRecord
implements RelationshipVisitor<RuntimeException>,
StorageRelationshipCursor,
RelationshipIds.UpdateListener {
    protected final CypherGraphStore graphStore;
    protected final TokenHolders tokenHolders;
    private final List<RelationshipIds.RelationshipIdContext> relationshipIdContexts;
    private final List<AdjacencyCursor> adjacencyCursorCache;
    private final List<PropertyCursor[]> propertyCursorCache;
    private MutableDoubleList propertyValuesCache;
    protected long maxRelationshipId;
    protected long sourceId;
    protected long targetId;
    protected RelationshipSelection selection;
    private AdjacencyCursor adjacencyCursor;
    private PropertyCursor[] propertyCursors;
    private int relationshipTypeOffset;
    private int relationshipContextIndex;
    private int[] propertyIds;

    public InMemoryRelationshipCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        super(-1L);
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        this.relationshipIdContexts = new ArrayList<RelationshipIds.RelationshipIdContext>();
        this.adjacencyCursorCache = new ArrayList<AdjacencyCursor>();
        this.propertyCursorCache = new ArrayList<PropertyCursor[]>();
        this.propertyValuesCache = new DoubleArrayList();
        this.maxRelationshipId = 0L;
        this.graphStore.relationshipIds().registerUpdateListener((RelationshipIds.UpdateListener)this);
    }

    public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws RuntimeException {
    }

    public int type() {
        return this.getType();
    }

    public long sourceNodeReference() {
        return this.sourceId;
    }

    public long targetNodeReference() {
        return this.targetId;
    }

    public boolean hasProperties() {
        return this.relationshipIdContexts.get(this.relationshipContextIndex).graph().hasRelationshipProperty();
    }

    public long entityReference() {
        return this.getId();
    }

    public boolean next() {
        while (this.adjacencyCursor == null || !this.adjacencyCursor.hasNextVLong()) {
            if (this.sourceId != -1L && this.progressToNextContext()) continue;
            return false;
        }
        this.targetId = this.adjacencyCursor.nextVLong();
        this.setId(this.getId() + 1L);
        for (int i = 0; i < this.propertyCursors.length; ++i) {
            this.propertyValuesCache.set(i, Double.longBitsToDouble(this.propertyCursors[i].nextLong()));
        }
        return true;
    }

    public void onRelationshipIdsAdded(RelationshipIds.RelationshipIdContext relationshipIdContext) {
        this.relationshipIdContexts.add(relationshipIdContext);
        this.adjacencyCursorCache.add(relationshipIdContext.adjacencyList().rawAdjacencyCursor());
        this.propertyCursorCache.add((PropertyCursor[])Arrays.stream(relationshipIdContext.adjacencyProperties()).map(AdjacencyProperties::rawPropertyCursor).toArray(PropertyCursor[]::new));
        int newSize = this.propertyCursorCache.stream().mapToInt(cursor -> ((PropertyCursor[])cursor).length).max().orElse(0);
        this.propertyValuesCache = new DoubleArrayList(new double[newSize]);
        this.maxRelationshipId += relationshipIdContext.relationshipCount();
    }

    public void reset() {
        this.relationshipContextIndex = -1;
        this.relationshipTypeOffset = 0;
        this.adjacencyCursor = null;
        this.targetId = -1L;
        this.sourceId = -1L;
        this.selection = null;
        this.setId(-1L);
    }

    protected void resetCursors() {
        this.relationshipContextIndex = -1;
        this.relationshipTypeOffset = 0;
        this.adjacencyCursor = null;
        this.setId(-1L);
    }

    public void setForceLoad() {
    }

    public void close() {
        this.graphStore.relationshipIds().removeUpdateListener((RelationshipIds.UpdateListener)this);
    }

    public void properties(StoragePropertyCursor propertyCursor, InMemoryPropertySelection selection) {
        AbstractInMemoryRelationshipPropertyCursor inMemoryCursor = (AbstractInMemoryRelationshipPropertyCursor)propertyCursor;
        inMemoryCursor.initRelationshipPropertyCursor(this.sourceId, this.propertyIds, (DoubleList)this.propertyValuesCache, selection);
    }

    private boolean progressToNextContext() {
        RelationshipIds.RelationshipIdContext context;
        ++this.relationshipContextIndex;
        if (this.relationshipContextIndex >= this.relationshipIdContexts.size()) {
            return false;
        }
        if (this.relationshipContextIndex > 0) {
            this.relationshipTypeOffset = (int)((long)this.relationshipTypeOffset + this.relationshipIdContexts.get(this.relationshipContextIndex - 1).relationshipCount());
        }
        if (!this.selection.test((context = this.relationshipIdContexts.get(this.relationshipContextIndex)).relationshipTypeId())) {
            return this.progressToNextContext();
        }
        this.initializeCursorForContext(context);
        this.setId((long)this.relationshipTypeOffset + context.offsets().get(this.sourceId) - 1L);
        return true;
    }

    protected void initializeForRelationshipReference(long reference) {
        this.graphStore.relationshipIds().resolveRelationshipId(reference, (nodeId, offset, context) -> {
            this.sourceId = nodeId;
            this.findContextAndInitializeCursor(context);
            for (long i = 0L; i < offset; ++i) {
                this.next();
            }
            this.setId(reference - 1L);
            return null;
        });
    }

    private void findContextAndInitializeCursor(RelationshipIds.RelationshipIdContext context) {
        while (this.progressToNextContext()) {
            if (this.relationshipIdContexts.get(this.relationshipContextIndex) != context) continue;
            return;
        }
        throw new IllegalStateException(StringFormatting.formatWithLocale((String)"No relationship context for relationship type %s was found", (Object[])new Object[]{context.relationshipType().name()}));
    }

    private void initializeCursorForContext(RelationshipIds.RelationshipIdContext context) {
        this.setType(context.relationshipTypeId());
        AdjacencyCursor reuseCursor = this.adjacencyCursorCache.get(this.relationshipContextIndex);
        this.adjacencyCursor = context.adjacencyList().adjacencyCursor(reuseCursor, this.sourceId);
        this.propertyIds = context.propertyIds();
        this.propertyCursors = this.propertyCursorCache.get(this.relationshipContextIndex);
        AdjacencyProperties[] adjacencyProperties = context.adjacencyProperties();
        for (int i = 0; i < this.propertyCursors.length; ++i) {
            adjacencyProperties[i].propertyCursor(this.propertyCursors[i], this.sourceId);
        }
    }
}

