/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.storageengine;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.core.cypher.UpdatableNodeProperty;
import org.neo4j.gds.core.cypher.nodeproperties.UpdatableDoubleArrayNodeProperty;
import org.neo4j.gds.core.cypher.nodeproperties.UpdatableDoubleNodeProperty;
import org.neo4j.gds.core.cypher.nodeproperties.UpdatableFloatArrayNodeProperty;
import org.neo4j.gds.core.cypher.nodeproperties.UpdatableLongArrayNodeProperty;
import org.neo4j.gds.core.cypher.nodeproperties.UpdatableLongNodeProperty;
import org.neo4j.gds.core.loading.ValueConverter;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;

public class InMemoryTransactionStateVisitor
extends TxStateVisitor.Adapter {
    private final CypherGraphStore graphStore;
    private final TokenHolders tokenHolders;
    private final IntObjectMap<UpdatableNodeProperty> nodePropertiesCache;

    public InMemoryTransactionStateVisitor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        this.nodePropertiesCache = new IntObjectHashMap();
    }

    public void visitNodePropertyChanges(long nodeId, Iterable<StorageProperty> added, Iterable<StorageProperty> changed, IntIterable removed) {
        this.visitNodePropertyChanges(nodeId, added.iterator(), changed.iterator(), removed);
    }

    public void visitNodePropertyChanges(long nodeId, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        if (!removed.isEmpty()) {
            throw new UnsupportedOperationException("Dropping single node properties is not supported. Use the `gds.graph.nodeProperties.drop` procedure instead to drop the entire property from the graph.");
        }
        this.visitAddedOrChangedNodeProperties(nodeId, added, changed);
    }

    public void removeNodeProperty(String propertyKey) {
        int propertyToken = this.tokenHolders.propertyKeyTokens().getIdByName(propertyKey);
        boolean usedByOtherLabels = this.graphStore.nodeLabels().stream().anyMatch(label -> this.graphStore.hasNodeProperty(label, propertyKey));
        if (!usedByOtherLabels) {
            this.nodePropertiesCache.remove(propertyToken);
        }
    }

    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
        added.forEach((LongProcedure & Serializable)addedLabelToken -> {
            try {
                String labelName = this.tokenHolders.labelTokens().getTokenById((int)addedLabelToken).name();
                this.graphStore.addLabelToNode(id, NodeLabel.of((String)labelName));
            }
            catch (TokenNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        removed.forEach((LongProcedure & Serializable)removedLabelToken -> {
            try {
                String labelName = this.tokenHolders.labelTokens().getTokenById((int)removedLabelToken).name();
                this.graphStore.removeLabelFromNode(id, NodeLabel.of((String)labelName));
            }
            catch (TokenNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void visitCreatedLabelToken(long id, String name, boolean internal) {
        this.graphStore.addNodeLabel(NodeLabel.of((String)name));
    }

    private void visitAddedOrChangedNodeProperties(long nodeId, Iterator<StorageProperty> added, Iterator<StorageProperty> changed) {
        Iterator addedOrChangedProperties = Iterators.concat((Iterator[])new Iterator[]{added, changed});
        addedOrChangedProperties.forEachRemaining(storageProperty -> {
            UpdatableNodeProperty nodeProperties;
            int propertyKeyId = storageProperty.propertyKeyId();
            String propertyKey = this.tokenHolders.propertyKeyGetName(propertyKeyId);
            Value propertyValue = storageProperty.value();
            if (this.nodePropertiesCache.containsKey(propertyKeyId)) {
                nodeProperties = (UpdatableNodeProperty)this.nodePropertiesCache.get(propertyKeyId);
            } else {
                nodeProperties = this.createUpdatableNodeProperty(propertyKeyId, propertyValue);
                this.graphStore.addNodeProperty(this.graphStore.nodeLabels(), propertyKey, (NodePropertyValues)nodeProperties);
            }
            nodeProperties.updatePropertyValue(nodeId, propertyValue);
        });
    }

    private UpdatableNodeProperty createUpdatableNodeProperty(int propertyKeyToken, Value value) {
        UpdatableNodeProperty updatableNodeProperty = this.updatableNodePropertyFromValue(value);
        this.nodePropertiesCache.put(propertyKeyToken, (Object)updatableNodeProperty);
        return updatableNodeProperty;
    }

    private UpdatableNodeProperty updatableNodePropertyFromValue(Value value) {
        ValueType valueType = ValueConverter.valueType((Value)value);
        DefaultValue defaultValue = valueType.fallbackValue();
        long nodeCount = this.graphStore.nodeCount();
        switch (valueType) {
            case LONG: {
                return new UpdatableLongNodeProperty(nodeCount, defaultValue.longValue());
            }
            case DOUBLE: {
                return new UpdatableDoubleNodeProperty(nodeCount, defaultValue.doubleValue());
            }
            case LONG_ARRAY: {
                return new UpdatableLongArrayNodeProperty(nodeCount, defaultValue.longArrayValue());
            }
            case DOUBLE_ARRAY: {
                return new UpdatableDoubleArrayNodeProperty(nodeCount, defaultValue.doubleArrayValue());
            }
            case FLOAT_ARRAY: {
                return new UpdatableFloatArrayNodeProperty(nodeCount, defaultValue.floatArrayValue());
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported property type %s", (Object[])new Object[]{value.getTypeName()}));
    }
}

