/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat.dev;

import java.nio.file.Path;
import java.util.UUID;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.gds.compat.dev.InMemoryCommandCreationContextImpl;
import org.neo4j.gds.compat.dev.InMemoryCountsStoreImpl;
import org.neo4j.gds.compat.dev.InMemoryMetaDataProviderImpl;
import org.neo4j.gds.compat.dev.InMemoryStorageEngineImpl;
import org.neo4j.gds.storageengine.InMemoryTransactionStateVisitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.AbstractInMemoryMetaDataProvider;
import org.neo4j.internal.recordstorage.AbstractInMemoryStorageEngineFactory;
import org.neo4j.internal.recordstorage.InMemoryStorageReaderDev;
import org.neo4j.internal.recordstorage.InMemoryStoreVersion;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.token.TokenHolders;

public class InMemoryStorageEngineFactoryDev
extends AbstractInMemoryStorageEngineFactory {
    public static final String IN_MEMORY_STORAGE_ENGINE_NAME_DEV = "in-memory-dev";
    private final AbstractInMemoryMetaDataProvider metadataProvider = new InMemoryMetaDataProviderImpl();

    public StorageEngine instantiate(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, PageCache pageCache, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, IdGeneratorFactory idGeneratorFactory, IdController idController, DatabaseHealth databaseHealth, LogProvider internalLogProvider, LogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer cacheTracer, boolean createStoreIfNotExists, DatabaseReadOnlyChecker readOnlyChecker, MemoryTracker memoryTracker) {
        StoreFactory factory = new StoreFactory(databaseLayout, config, idGeneratorFactory, pageCache, fs, internalLogProvider, cacheTracer, readOnlyChecker);
        factory.openNeoStores(createStoreIfNotExists, new StoreType[]{StoreType.LABEL_TOKEN});
        return new InMemoryStorageEngineImpl.Builder(databaseLayout, tokenHolders, (MetadataProvider)this.metadataProvider).withCommandCreationContextSupplier(InMemoryCommandCreationContextImpl::new).withStorageReaderFn(InMemoryStorageReaderDev::new).withTxStateVisitorFn(InMemoryTransactionStateVisitor::new).withCountsStoreFn(InMemoryCountsStoreImpl::new).withCommandCreationContextSupplier(InMemoryCommandCreationContextImpl::new).build();
    }

    public void setExternalStoreUUID(FileSystemAbstraction fileSystemAbstraction, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext, UUID uuid) {
        MetaDataStore.getDatabaseIdUuid((PageCache)pageCache, (Path)RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout).metadataStore(), (String)databaseLayout.getDatabaseName(), (CursorContext)cursorContext);
    }

    public DatabaseLayout databaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        return RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)databaseName);
    }

    public String name() {
        return IN_MEMORY_STORAGE_ENGINE_NAME_DEV;
    }

    public StoreVersion versionInformation(StoreId storeId) {
        return new InMemoryStoreVersion();
    }

    protected AbstractInMemoryMetaDataProvider metadataProvider() {
        return this.metadataProvider;
    }
}

