/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat.dev;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.neo4j.counts.CountsStore;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.TriFunction;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.compat.AbstractInMemoryStorageEngine;
import org.neo4j.gds.compat.InMemoryStorageEngineBuilder;
import org.neo4j.gds.compat.dev.InMemoryStorageLocksImpl;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.token.TokenHolders;

public class InMemoryStorageEngineImpl
extends AbstractInMemoryStorageEngine {
    public InMemoryStorageEngineImpl(DatabaseLayout databaseLayout, TokenHolders tokenHolders, BiFunction<GraphStore, TokenHolders, CountsStore> countsStoreFn, BiFunction<GraphStore, TokenHolders, TxStateVisitor> txStateVisitorFn, MetadataProvider metadataProvider, Supplier<CommandCreationContext> commandCreationContextSupplier, TriFunction<GraphStore, TokenHolders, CountsStore, StorageReader> storageReaderFn) {
        super(databaseLayout, tokenHolders, countsStoreFn, txStateVisitorFn, metadataProvider, commandCreationContextSupplier, storageReaderFn);
    }

    public StoreEntityCounters storeEntityCounters() {
        return new StoreEntityCounters(){

            public long nodes() {
                return InMemoryStorageEngineImpl.this.graphStore.nodeCount();
            }

            public long relationships() {
                return InMemoryStorageEngineImpl.this.graphStore.relationshipCount();
            }

            public long properties() {
                HashSet properties = new HashSet();
                InMemoryStorageEngineImpl.this.graphStore.nodePropertyKeys().values().forEach(properties::addAll);
                return properties.size() + InMemoryStorageEngineImpl.this.graphStore.relationshipPropertyKeys().size();
            }

            public long relationshipTypes() {
                return InMemoryStorageEngineImpl.this.graphStore.relationshipTypes().size();
            }

            public long allNodesCountStore(CursorContext cursorContext) {
                return InMemoryStorageEngineImpl.this.graphStore.nodeCount();
            }

            public long allRelationshipsCountStore(CursorContext cursorContext) {
                return InMemoryStorageEngineImpl.this.graphStore.relationshipCount();
            }
        };
    }

    public StoreCursors createStorageCursors(CursorContext initialContext) {
        return StoreCursors.NULL;
    }

    public StorageLocks createStorageLocks(ResourceLocker locker) {
        return new InMemoryStorageLocksImpl(locker);
    }

    public void createCommands(Collection<StorageCommand> target, ReadableTransactionState txState, StorageReader storageReader, CommandCreationContext creationContext, ResourceLocker locks, LockTracer lockTracer, long lastTransactionIdWhenStarted, TxStateVisitor.Decorator additionalTxStateVisitor, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) throws KernelException {
        super.createCommands(txState);
    }

    public static final class Builder
    extends InMemoryStorageEngineBuilder<InMemoryStorageEngineImpl> {
        public Builder(DatabaseLayout databaseLayout, TokenHolders tokenHolders, MetadataProvider metadataProvider) {
            super(databaseLayout, tokenHolders, metadataProvider);
        }

        public InMemoryStorageEngineImpl build() {
            return new InMemoryStorageEngineImpl(this.databaseLayout, this.tokenHolders, this.countsStoreFn, this.txStateVisitorFn, this.metadataProvider, this.commandCreationContextSupplier, (TriFunction<GraphStore, TokenHolders, CountsStore, StorageReader>)this.storageReaderFn);
        }
    }
}

