/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat.dev;

import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.compat.AbstractInMemoryNodeCursor;
import org.neo4j.gds.compat.AbstractInMemoryNodePropertyCursor;
import org.neo4j.gds.compat.AbstractInMemoryRelationshipTraversalCursor;
import org.neo4j.gds.compat.StorageEngineProxyApi;
import org.neo4j.gds.compat.dev.InMemoryCommandCreationContextImpl;
import org.neo4j.gds.compat.dev.InMemoryCountsStoreImpl;
import org.neo4j.gds.compat.dev.InMemoryMetaDataProviderImpl;
import org.neo4j.gds.compat.dev.InMemoryNodeCursor;
import org.neo4j.gds.compat.dev.InMemoryNodePropertyCursor;
import org.neo4j.gds.compat.dev.InMemoryRelationshipTraversalCursor;
import org.neo4j.gds.compat.dev.InMemoryStorageEngineImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.recordstorage.InMemoryStorageReaderDev;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.token.TokenHolders;

public class StorageEngineProxyImpl
implements StorageEngineProxyApi {
    public InMemoryStorageEngineImpl.Builder inMemoryStorageEngineBuilder(DatabaseLayout databaseLayout, TokenHolders tokenHolders) {
        return new InMemoryStorageEngineImpl.Builder(databaseLayout, tokenHolders, (MetadataProvider)new InMemoryMetaDataProviderImpl());
    }

    public CountsStore inMemoryCountsStore(GraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryCountsStoreImpl(graphStore, tokenHolders);
    }

    public CommandCreationContext inMemoryCommandCreationContext() {
        return new InMemoryCommandCreationContextImpl();
    }

    public void initRelationshipTraversalCursorForRelType(StorageRelationshipTraversalCursor cursor, long sourceNodeId, int relTypeToken) {
        RelationshipSelection relationshipSelection = RelationshipSelection.selection((int)relTypeToken, (Direction)Direction.OUTGOING);
        cursor.init(sourceNodeId, -1L, relationshipSelection);
    }

    public StorageReader inMemoryStorageReader(GraphStore graphStore, TokenHolders tokenHolders, CountsAccessor counts) {
        return new InMemoryStorageReaderDev(graphStore, tokenHolders, counts);
    }

    public void createInMemoryDatabase(DatabaseManagementService dbms, String dbName, Config config) {
        config.set(GraphDatabaseInternalSettings.storage_engine, (Object)"in-memory-dev");
        dbms.createDatabase(dbName, (Configuration)config);
    }

    public GraphDatabaseAPI startAndGetInMemoryDatabase(DatabaseManagementService dbms, String dbName) {
        dbms.startDatabase(dbName);
        return (GraphDatabaseAPI)dbms.database(dbName);
    }

    public DatabaseManagementServiceBuilder setSkipDefaultIndexesOnCreationSetting(DatabaseManagementServiceBuilder dbmsBuilder) {
        return dbmsBuilder.setConfig(GraphDatabaseInternalSettings.skip_default_indexes_on_creation, (Object)true);
    }

    public AbstractInMemoryNodeCursor inMemoryNodeCursor(GraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryNodeCursor(graphStore, tokenHolders);
    }

    public AbstractInMemoryNodePropertyCursor inMemoryNodePropertyCursor(GraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryNodePropertyCursor(graphStore, tokenHolders);
    }

    public AbstractInMemoryRelationshipTraversalCursor inMemoryRelationshipTraversalCursor(GraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryRelationshipTraversalCursor(graphStore, tokenHolders);
    }

    public Edition dbmsEdition(GraphDatabaseAPI api) {
        return api.dbmsInfo().edition;
    }
}

