/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.compat.dev.InMemoryNodeCursor;
import org.neo4j.gds.compat.dev.InMemoryPropertyCursor;
import org.neo4j.gds.compat.dev.InMemoryRelationshipTraversalCursor;
import org.neo4j.internal.recordstorage.AbstractInMemoryStorageReader;
import org.neo4j.internal.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;

public class InMemoryStorageReaderDev
extends AbstractInMemoryStorageReader {
    public InMemoryStorageReaderDev(GraphStore graphStore, TokenHolders tokenHolders, CountsAccessor counts) {
        super(graphStore, tokenHolders, counts);
    }

    public long relationshipsGetCount(CursorContext cursorTracer) {
        return this.graphStore.relationshipCount();
    }

    public boolean nodeExists(long id, StoreCursors storeCursors) {
        return super.nodeExists(id);
    }

    public boolean relationshipExists(long id, StoreCursors storeCursors) {
        return true;
    }

    public StorageNodeCursor allocateNodeCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new InMemoryNodeCursor(this.graphStore, this.tokenHolders);
    }

    public StoragePropertyCursor allocatePropertyCursor(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return new InMemoryPropertyCursor(this.graphStore, this.tokenHolders);
    }

    public StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new InMemoryRelationshipTraversalCursor(this.graphStore, this.tokenHolders);
    }

    public StorageRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new RecordRelationshipScanCursor(null, cursorContext);
    }

    public IndexDescriptor indexGetForSchemaAndType(SchemaDescriptor descriptor, IndexType type) {
        return null;
    }
}

