/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.storageengine.api.RelationshipDirection;

public class TestRelationshipChain {
    private List<Data> data;
    private long originNodeId;

    public TestRelationshipChain(long originNodeId) {
        this(originNodeId, new ArrayList<Data>());
    }

    private TestRelationshipChain(long originNodeId, List<Data> data) {
        this.originNodeId = originNodeId;
        this.data = data;
    }

    public TestRelationshipChain outgoing(long id, long targetNode, int type) {
        this.data.add(new Data(id, this.originNodeId, targetNode, type));
        return this;
    }

    public TestRelationshipChain incoming(long id, long sourceNode, int type) {
        this.data.add(new Data(id, sourceNode, this.originNodeId, type));
        return this;
    }

    public TestRelationshipChain loop(long id, int type) {
        this.data.add(new Data(id, this.originNodeId, this.originNodeId, type));
        return this;
    }

    public Data get(int offset) {
        return this.data.get(offset);
    }

    boolean isValidOffset(int offset) {
        return offset >= 0 && offset < this.data.size();
    }

    long originNodeId() {
        return this.originNodeId;
    }

    public TestRelationshipChain tail() {
        return new TestRelationshipChain(this.originNodeId, this.data.subList(1, this.data.size()));
    }

    static class Data {
        final long id;
        final long source;
        final long target;
        final int type;

        Data(long id, long source, long target, int type) {
            this.id = id;
            this.source = source;
            this.target = target;
            this.type = type;
        }

        RelationshipDirection relationshipDirection(long nodeReference) {
            if (this.source == this.target) {
                return RelationshipDirection.LOOP;
            }
            return nodeReference == this.source ? RelationshipDirection.OUTGOING : RelationshipDirection.INCOMING;
        }

        public String toString() {
            return String.format("(%d)-[%d,type:%d]->(%d)", this.source, this.id, this.type, this.target);
        }
    }
}

