/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.restore;

import java.io.File;
import java.io.IOException;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;

public class RestoreDatabaseCommand {
    private FileSystemAbstraction fs;
    private final File fromPath;
    private final File databaseDir;
    private String databaseName;
    private boolean forceOverwrite;

    public RestoreDatabaseCommand(FileSystemAbstraction fs, File fromPath, Config config, String databaseName, boolean forceOverwrite) {
        this.fs = fs;
        this.fromPath = fromPath;
        this.databaseName = databaseName;
        this.forceOverwrite = forceOverwrite;
        this.databaseDir = ((File)config.get(DatabaseManagementSystemSettings.database_path)).getAbsoluteFile();
    }

    public void execute() throws IOException {
        if (!this.fs.fileExists(this.fromPath)) {
            throw new IllegalArgumentException(String.format("Source directory does not exist [%s]", this.fromPath));
        }
        if (this.fs.fileExists(this.databaseDir) && !this.forceOverwrite) {
            throw new IllegalArgumentException(String.format("Database with name [%s] already exists at %s", this.databaseName, this.databaseDir));
        }
        this.fs.deleteRecursively(this.databaseDir);
        this.fs.copyRecursively(this.fromPath, this.databaseDir);
    }
}

