/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.BufferReusingChunkingChannelBuffer;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.ChunkingChannelBuffer;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Server;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

class BackupServer
extends Server<TheBackupInterface, Object> {
    private static final long DEFAULT_OLD_CHANNEL_THRESHOLD = 20000L;
    private static final int DEFAULT_MAX_CONCURRENT_TX = 3;
    private static final BackupClient.BackupRequestType[] contexts = BackupClient.BackupRequestType.values();
    public static final ProtocolVersion BACKUP_PROTOCOL_VERSION = new ProtocolVersion(2, 2);
    static final int DEFAULT_PORT = 6362;
    static final int FRAME_LENGTH = 0x400000;

    BackupServer(TheBackupInterface requestTarget, HostnamePort server, LogProvider logProvider, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor) {
        super((Object)requestTarget, BackupServer.newBackupConfig(0x400000, server), logProvider, 0x400000, BACKUP_PROTOCOL_VERSION, TxChecksumVerifier.ALWAYS_MATCH, Clocks.systemClock(), byteCounterMonitor, requestMonitor);
    }

    protected ChunkingChannelBuffer newChunkingBuffer(ChannelBuffer bufferToWriteTo, Channel channel, int capacity, byte internalProtocolVersion, byte applicationProtocolVersion) {
        return new BufferReusingChunkingChannelBuffer(bufferToWriteTo, channel, capacity, internalProtocolVersion, applicationProtocolVersion);
    }

    private static Server.Configuration newBackupConfig(final int chunkSize, final HostnamePort server) {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return 20000L;
            }

            public int getMaxConcurrentTransactions() {
                return 3;
            }

            public int getChunkSize() {
                return chunkSize;
            }

            public HostnamePort getServerAddress() {
                return server;
            }
        };
    }

    protected void responseWritten(RequestType<TheBackupInterface> type, Channel channel, RequestContext context) {
    }

    protected RequestType<TheBackupInterface> getRequestContext(byte id) {
        return contexts[id];
    }

    protected void stopConversation(RequestContext context) {
    }
}

