/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.ConsistencyCheckFailedException;
import org.neo4j.backup.IncrementalBackupNotPossibleException;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ExternallyManagedPageCache;
import org.neo4j.com.storecopy.MoveAfterCopy;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.consistency.checking.full.CheckConsistencyConfig;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.transaction.log.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

class BackupService {
    static final String TOO_OLD_BACKUP = "It's been too long since this backup was last updated, and it has fallen too far behind the database transaction stream for incremental backup to be possible. You need to perform a full backup at this point. You can modify this time interval by setting the '" + GraphDatabaseSettings.keep_logical_logs.name() + "' configuration on the database to a higher value.";
    static final String DIFFERENT_STORE = "Target directory contains full backup of a logically different store.";
    private final Supplier<FileSystemAbstraction> fileSystemSupplier;
    private final LogProvider logProvider;
    private final Log log;
    private final Monitors monitors;

    BackupService() {
        this(System.out);
    }

    BackupService(OutputStream logDestination) {
        this(DefaultFileSystemAbstraction::new, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)logDestination), new Monitors());
    }

    BackupService(Supplier<FileSystemAbstraction> fileSystemSupplier, LogProvider logProvider, Monitors monitors) {
        this.fileSystemSupplier = fileSystemSupplier;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.monitors = monitors;
        monitors.addMonitorListener((Object)new StoreCopyClientLoggingMonitor(this.log), new String[]{this.getClass().getName()});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BackupOutcome doFullBackup(String sourceHostNameOrIp, int sourcePort, File targetDirectory, ConsistencyCheck consistencyCheck, Config tuningConfiguration, long timeout, boolean forensics) {
        try (FileSystemAbstraction fileSystem = this.fileSystemSupplier.get();){
            BackupOutcome backupOutcome = this.fullBackup(fileSystem, sourceHostNameOrIp, sourcePort, targetDirectory, consistencyCheck, tuningConfiguration, timeout, forensics);
            return backupOutcome;
        }
        catch (IOException e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BackupOutcome fullBackup(FileSystemAbstraction fileSystem, String sourceHostNameOrIp, int sourcePort, File targetDirectory, ConsistencyCheck consistencyCheck, Config tuningConfiguration, long timeout, boolean forensics) {
        if (!this.directoryIsEmpty(fileSystem, targetDirectory)) {
            throw new RuntimeException("Can only perform a full backup into an empty directory but " + targetDirectory + " is not empty");
        }
        long timestamp = System.currentTimeMillis();
        long lastCommittedTx = -1L;
        try (PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (Config)tuningConfiguration);){
            StoreCopyClient storeCopier = new StoreCopyClient(targetDirectory, tuningConfiguration, this.loadKernelExtensions(), this.logProvider, fileSystem, pageCache, (StoreCopyClient.Monitor)this.monitors.newMonitor(StoreCopyClient.Monitor.class, this.getClass(), new String[0]), forensics);
            FullBackupStoreCopyRequester storeCopyRequester = new FullBackupStoreCopyRequester(sourceHostNameOrIp, sourcePort, timeout, forensics, this.monitors);
            storeCopier.copyStore((StoreCopyClient.StoreCopyRequester)storeCopyRequester, CancellationRequest.NEVER_CANCELLED, MoveAfterCopy.moveReplaceExisting());
            BackupService.bumpDebugDotLogFileVersion(targetDirectory, timestamp);
            boolean consistent = this.checkDbConsistency(fileSystem, targetDirectory, consistencyCheck, tuningConfiguration, pageCache);
            this.clearIdFiles(fileSystem, targetDirectory);
            BackupOutcome backupOutcome = new BackupOutcome(lastCommittedTx, consistent);
            return backupOutcome;
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, File targetDirectory, ConsistencyCheck consistencyCheck, long timeout, Config config) throws IncrementalBackupNotPossibleException {
        try (FileSystemAbstraction fileSystem = this.fileSystemSupplier.get();){
            BackupOutcome backupOutcome = this.incrementalBackup(fileSystem, sourceHostNameOrIp, sourcePort, targetDirectory, consistencyCheck, timeout, config);
            return backupOutcome;
        }
        catch (IOException e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BackupOutcome incrementalBackup(FileSystemAbstraction fileSystem, String sourceHostNameOrIp, int sourcePort, File targetDirectory, ConsistencyCheck consistencyCheck, long timeout, Config config) {
        if (!this.directoryContainsDb(fileSystem, targetDirectory)) {
            throw new RuntimeException(targetDirectory + " doesn't contain a database");
        }
        Map<String, String> temporaryDbConfig = this.getTemporaryDbConfig();
        config = config.with(temporaryDbConfig);
        HashMap<String, String> configParams = new HashMap<String, String>();
        Set keys = config.getConfiguredSettingKeys();
        for (String key : keys) {
            Optional value = config.getRaw(key);
            value.ifPresent(s -> configParams.put(key, (String)s));
        }
        try (PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (Config)config);){
            long lastCommittedTx;
            GraphDatabaseAPI targetDb = BackupService.startTemporaryDb(targetDirectory, pageCache, configParams);
            long backupStartTime = System.currentTimeMillis();
            try {
                lastCommittedTx = this.incrementalWithContext(sourceHostNameOrIp, sourcePort, targetDb, timeout, this.slaveContextOf(targetDb));
            }
            finally {
                targetDb.shutdown();
            }
            BackupService.bumpDebugDotLogFileVersion(targetDirectory, backupStartTime);
            boolean consistent = this.checkDbConsistency(fileSystem, targetDirectory, consistencyCheck, config, pageCache);
            this.clearIdFiles(fileSystem, targetDirectory);
            BackupOutcome backupOutcome = new BackupOutcome(lastCommittedTx, consistent);
            return backupOutcome;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkDbConsistency(FileSystemAbstraction fileSystem, File targetDirectory, ConsistencyCheck consistencyCheck, Config tuningConfiguration, PageCache pageCache) {
        boolean consistent = false;
        try {
            consistent = consistencyCheck.runFull(targetDirectory, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err), this.logProvider, fileSystem, pageCache, false, new CheckConsistencyConfig(tuningConfiguration));
        }
        catch (ConsistencyCheckFailedException e) {
            this.log.error("Consistency check incomplete", (Throwable)e);
        }
        return consistent;
    }

    private Map<String, String> getTemporaryDbConfig() {
        HashMap<String, String> tempDbConfig = new HashMap<String, String>();
        tempDbConfig.put(OnlineBackupSettings.online_backup_enabled.name(), "false");
        tempDbConfig.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
        return tempDbConfig;
    }

    /*
     * Exception decompiling
     */
    BackupOutcome doIncrementalBackupOrFallbackToFull(String sourceHostNameOrIp, int sourcePort, File targetDirectory, ConsistencyCheck consistencyCheck, Config config, long timeout, boolean forensics) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK], 10[TRYBLOCK], 3[TRYBLOCK], 16[CATCHBLOCK], 18[CATCHBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, long timeout) throws IncrementalBackupNotPossibleException {
        long lastCommittedTransaction = this.incrementalWithContext(sourceHostNameOrIp, sourcePort, targetDb, timeout, this.slaveContextOf(targetDb));
        return new BackupOutcome(lastCommittedTransaction, true);
    }

    private RequestContext slaveContextOf(GraphDatabaseAPI graphDb) {
        TransactionIdStore transactionIdStore = (TransactionIdStore)graphDb.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return RequestContext.anonymous((long)transactionIdStore.getLastCommittedTransactionId());
    }

    boolean directoryContainsDb(FileSystemAbstraction fileSystem, File targetDirectory) {
        return fileSystem.fileExists(new File(targetDirectory, "neostore"));
    }

    private boolean directoryIsEmpty(FileSystemAbstraction fileSystem, File targetDirectory) {
        return !fileSystem.isDirectory(targetDirectory) || 0 == fileSystem.listFiles(targetDirectory).length;
    }

    private static GraphDatabaseAPI startTemporaryDb(File targetDirectory, PageCache pageCache, Map<String, String> config) {
        ExternallyManagedPageCache.GraphDatabaseFactoryWithPageCacheFactory factory = ExternallyManagedPageCache.graphDatabaseFactoryWithPageCache((PageCache)pageCache);
        return (GraphDatabaseAPI)factory.newEmbeddedDatabaseBuilder(targetDirectory).setConfig(config).newGraphDatabase();
    }

    private long incrementalWithContext(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, long timeout, RequestContext context) throws IncrementalBackupNotPossibleException {
        DependencyResolver resolver = targetDb.getDependencyResolver();
        ProgressTxHandler handler = new ProgressTxHandler();
        TransactionCommittingResponseUnpacker unpacker = new TransactionCommittingResponseUnpacker(resolver, 100, 0L);
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        LogProvider logProvider = ((LogService)resolver.resolveDependency(LogService.class)).getInternalLogProvider();
        BackupClient client = new BackupClient(sourceHostNameOrIp, sourcePort, null, logProvider, targetDb.storeId(), timeout, (ResponseUnpacker)unpacker, (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, BackupClient.class, new String[0]), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, BackupClient.class, new String[0]), (LogEntryReader<ReadableClosablePositionAwareChannel>)new VersionAwareLogEntryReader());
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{unpacker, client});
             Response<Void> response = client.incrementalBackup(context);){
            unpacker.unpackResponse(response, (ResponseUnpacker.TxHandler)handler);
        }
        catch (MismatchingStoreIdException e) {
            throw new RuntimeException(DIFFERENT_STORE, e);
        }
        catch (IOException | RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof MissingLogDataException) {
                throw new IncrementalBackupNotPossibleException(TOO_OLD_BACKUP, e.getCause());
            }
            if (e.getCause() != null && e.getCause() instanceof ConnectException) {
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
            throw new RuntimeException("Failed to perform incremental backup.", e);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unexpected error", throwable);
        }
        return handler.getLastSeenTransactionId();
    }

    private static boolean bumpDebugDotLogFileVersion(File dbDirectory, long toTimestamp) {
        File[] candidates = dbDirectory.listFiles((dir, name) -> name.equals("debug.log"));
        if (candidates == null || candidates.length != 1) {
            return false;
        }
        File previous = candidates[0];
        File to = new File(previous.getParentFile(), "debug.log." + toTimestamp);
        return previous.renameTo(to);
    }

    private List<KernelExtensionFactory<?>> loadKernelExtensions() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        return kernelExtensions;
    }

    private void clearIdFiles(FileSystemAbstraction fileSystem, File targetDirectory) throws IOException {
        for (File file : fileSystem.listFiles(targetDirectory)) {
            if (fileSystem.isDirectory(file) || !file.getName().endsWith(".id")) continue;
            long highId = IdGeneratorImpl.readHighId((FileSystemAbstraction)fileSystem, (File)file);
            fileSystem.deleteFile(file);
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)fileSystem, (File)file, (long)highId, (boolean)true);
        }
    }

    private static class StoreCopyClientLoggingMonitor
    implements StoreCopyClient.Monitor {
        private final Log log;

        StoreCopyClientLoggingMonitor(Log log) {
            this.log = log;
        }

        public void startReceivingStoreFiles() {
            this.log.debug("Start receiving store files");
        }

        public void finishReceivingStoreFiles() {
            this.log.debug("Finish receiving store files");
        }

        public void startReceivingStoreFile(File file) {
            this.log.debug("Start receiving store file %s", new Object[]{file});
        }

        public void finishReceivingStoreFile(File file) {
            this.log.debug("Finish receiving store file %s", new Object[]{file});
        }

        public void startReceivingTransactions(long startTxId) {
            this.log.info("Start receiving transactions from %d", new Object[]{startTxId});
        }

        public void finishReceivingTransactions(long endTxId) {
            this.log.info("Finish receiving transactions at %d", new Object[]{endTxId});
        }

        public void startRecoveringStore() {
            this.log.info("Start recovering store");
        }

        public void finishRecoveringStore() {
            this.log.info("Finish recovering store");
        }
    }

    private static class FullBackupStoreCopyRequester
    implements StoreCopyClient.StoreCopyRequester {
        private final String sourceHostNameOrIp;
        private final int sourcePort;
        private final long timeout;
        private final boolean forensics;
        private final Monitors monitors;
        private BackupClient client;

        private FullBackupStoreCopyRequester(String sourceHostNameOrIp, int sourcePort, long timeout, boolean forensics, Monitors monitors) {
            this.sourceHostNameOrIp = sourceHostNameOrIp;
            this.sourcePort = sourcePort;
            this.timeout = timeout;
            this.forensics = forensics;
            this.monitors = monitors;
        }

        public Response<?> copyStore(StoreWriter writer) {
            this.client = new BackupClient(this.sourceHostNameOrIp, this.sourcePort, null, (LogProvider)NullLogProvider.getInstance(), StoreId.DEFAULT, this.timeout, ResponseUnpacker.NO_OP_RESPONSE_UNPACKER, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, new String[0]), (LogEntryReader<ReadableClosablePositionAwareChannel>)new VersionAwareLogEntryReader());
            this.client.start();
            return this.client.fullBackup(writer, this.forensics);
        }

        public void done() {
            this.client.stop();
        }
    }

    private static class ProgressTxHandler
    implements ResponseUnpacker.TxHandler {
        private long lastSeenTransactionId;

        private ProgressTxHandler() {
        }

        public void accept(long transactionId) {
            this.lastSeenTransactionId = transactionId;
        }

        long getLastSeenTransactionId() {
            return this.lastSeenTransactionId;
        }
    }

    class BackupOutcome {
        private final boolean consistent;
        private final long lastCommittedTx;

        BackupOutcome(long lastCommittedTx, boolean consistent) {
            this.lastCommittedTx = lastCommittedTx;
            this.consistent = consistent;
        }

        long getLastCommittedTx() {
            return this.lastCommittedTx;
        }

        public boolean isConsistent() {
            return this.consistent;
        }
    }
}

