/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class OnlineBackup {
    private final String hostNameOrIp;
    private final int port;
    private boolean forensics;
    private BackupService.BackupOutcome outcome;
    private long timeoutMillis = BackupClient.BIG_READ_TIMEOUT;

    public static OnlineBackup from(String hostNameOrIp, int port) {
        return new OnlineBackup(hostNameOrIp, port);
    }

    public static OnlineBackup from(String hostNameOrIp) {
        return new OnlineBackup(hostNameOrIp, 6362);
    }

    private OnlineBackup(String hostNameOrIp, int port) {
        this.hostNameOrIp = hostNameOrIp;
        this.port = port;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory) {
        return this.backup(new File(targetDirectory));
    }

    public OnlineBackup backup(File targetDirectory) {
        this.outcome = new BackupService().doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, targetDirectory, OnlineBackup.getConsistencyCheck(true), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, boolean verification) {
        return this.backup(new File(targetDirectory), verification);
    }

    public OnlineBackup backup(File targetDirectory, boolean verification) {
        this.outcome = new BackupService().doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, targetDirectory, OnlineBackup.getConsistencyCheck(verification), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, Config tuningConfiguration) {
        return this.backup(new File(targetDirectory), tuningConfiguration);
    }

    public OnlineBackup backup(File targetDirectory, Config tuningConfiguration) {
        this.outcome = new BackupService().doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, targetDirectory, OnlineBackup.getConsistencyCheck(true), tuningConfiguration, this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup backup(String targetDirectory, Config tuningConfiguration, boolean verification) {
        return this.backup(new File(targetDirectory), tuningConfiguration, verification);
    }

    public OnlineBackup backup(File targetDirectory, Config tuningConfiguration, boolean verification) {
        this.outcome = new BackupService().doIncrementalBackupOrFallbackToFull(this.hostNameOrIp, this.port, targetDirectory, OnlineBackup.getConsistencyCheck(verification), tuningConfiguration, this.timeoutMillis, this.forensics);
        return this;
    }

    public OnlineBackup withTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory) {
        this.outcome = new BackupService().doFullBackup(this.hostNameOrIp, this.port, new File(targetDirectory), OnlineBackup.getConsistencyCheck(true), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory, boolean verification) {
        this.outcome = new BackupService().doFullBackup(this.hostNameOrIp, this.port, new File(targetDirectory), OnlineBackup.getConsistencyCheck(verification), this.defaultConfig(), this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup full(String targetDirectory, boolean verification, Config tuningConfiguration) {
        this.outcome = new BackupService().doFullBackup(this.hostNameOrIp, this.port, new File(targetDirectory), OnlineBackup.getConsistencyCheck(verification), tuningConfiguration, this.timeoutMillis, this.forensics);
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(String targetDirectory) {
        this.outcome = new BackupService().doIncrementalBackup(this.hostNameOrIp, this.port, new File(targetDirectory), OnlineBackup.getConsistencyCheck(false), this.timeoutMillis, this.defaultConfig());
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(String targetDirectory, boolean verification) {
        this.outcome = new BackupService().doIncrementalBackup(this.hostNameOrIp, this.port, new File(targetDirectory), OnlineBackup.getConsistencyCheck(verification), this.timeoutMillis, this.defaultConfig());
        return this;
    }

    @Deprecated
    public OnlineBackup incremental(GraphDatabaseAPI targetDb) {
        this.outcome = new BackupService().doIncrementalBackup(this.hostNameOrIp, this.port, targetDb, this.timeoutMillis);
        return this;
    }

    public long getLastCommittedTx() {
        return this.outcome().getLastCommittedTx();
    }

    public boolean isConsistent() {
        return this.outcome().isConsistent();
    }

    private BackupService.BackupOutcome outcome() {
        if (this.outcome == null) {
            throw new IllegalStateException("No outcome yet. Please call full or incremental backup first");
        }
        return this.outcome;
    }

    private Config defaultConfig() {
        return Config.embeddedDefaults((ConfigurationValidator[])new ConfigurationValidator[0]);
    }

    public OnlineBackup gatheringForensics(boolean forensics) {
        this.forensics = forensics;
        return this;
    }

    private static ConsistencyCheck getConsistencyCheck(boolean verification) {
        return verification ? ConsistencyCheck.FULL : ConsistencyCheck.NONE;
    }
}

