/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.ConsistencyCheckFailedException;
import org.neo4j.backup.IncrementalBackupNotPossibleException;
import org.neo4j.backup.OnlineBackupExtensionFactory;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.com.ports.allocation.PortAuthority;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.consistency.checking.full.CheckConsistencyConfig;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.storemigration.LogFiles;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependenciesProxy;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Barrier;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class BackupServiceIT {
    private static final String NODE_STORE = ".nodestore.db";
    private static final String RELATIONSHIP_STORE = ".relationshipstore.db";
    private static final String BACKUP_HOST = "localhost";
    private static final OutputStream NULL_OUTPUT = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    private final Monitors monitors = new Monitors();
    private final IOLimiter limiter = IOLimiter.unlimited();
    private FileSystemAbstraction fileSystem;
    private File storeDir;
    private File backupDir;
    private int backupPort = -1;
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final TestDirectory target = TestDirectory.testDirectory();
    private final EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule().startLazily();
    private final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.target).around((TestRule)this.dbRule).around((TestRule)this.pageCacheRule).around((TestRule)this.suppressOutput);

    @Before
    public void setup() {
        this.fileSystem = this.fileSystemRule.get();
        this.backupPort = PortAuthority.allocatePort();
        this.storeDir = this.dbRule.getStoreDirFile();
        this.backupDir = this.target.directory("backup_dir");
    }

    private BackupService backupService() {
        return new BackupService(() -> new UncloseableDelegatingFileSystemAbstraction(this.fileSystemRule.get()), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)NULL_OUTPUT), NULL_OUTPUT, new Monitors());
    }

    private BackupService backupService(LogProvider logProvider) {
        return new BackupService(() -> new UncloseableDelegatingFileSystemAbstraction(this.fileSystemRule.get()), logProvider, NULL_OUTPUT, new Monitors());
    }

    @Test
    public void performConsistencyCheckAfterIncrementalBackup() {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        this.backupService().doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        TestFullConsistencyCheck consistencyCheck = new TestFullConsistencyCheck();
        BackupService.BackupOutcome backupOutcome = this.backupService().doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir, (ConsistencyCheck)consistencyCheck, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        Assert.assertTrue((String)"Consistency check invoked for incremental backup, ", (boolean)consistencyCheck.isChecked());
        Assert.assertTrue((boolean)backupOutcome.isConsistent());
    }

    @Test
    public void shouldPrintThatFullBackupIsPerformed() throws Exception {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        final Log log = (Log)Mockito.mock(Log.class);
        LogProvider logProvider = new LogProvider(){

            public Log getLog(Class loggingClass) {
                return log;
            }

            public Log getLog(String name) {
                return log;
            }
        };
        this.backupService(logProvider).doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        ((Log)Mockito.verify((Object)log)).info("Previous backup not found, a new full backup will be performed.");
    }

    @Test
    public void shouldPrintThatIncrementalBackupIsPerformedAndFallingBackToFull() throws Exception {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        this.dbRule.setConfig(GraphDatabaseSettings.keep_logical_logs, "false");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        this.backupService().doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        this.createAndIndexNode((GraphDatabaseService)db, 2);
        this.rotateAndCheckPoint(db);
        this.createAndIndexNode((GraphDatabaseService)db, 3);
        this.rotateAndCheckPoint(db);
        this.createAndIndexNode((GraphDatabaseService)db, 4);
        this.rotateAndCheckPoint(db);
        final Log log = (Log)Mockito.mock(Log.class);
        LogProvider logProvider = new LogProvider(){

            public Log getLog(Class loggingClass) {
                return log;
            }

            public Log getLog(String name) {
                return log;
            }
        };
        this.backupService(logProvider).doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        ((Log)Mockito.verify((Object)log)).info("Previous backup found, trying incremental backup.");
        ((Log)Mockito.verify((Object)log)).info("Existing backup is too far out of date, a new full backup will be performed.");
    }

    @Test
    public void shouldThrowUsefulMessageWhenCannotConnectDuringFullBackup() throws Exception {
        try {
            this.backupService().doIncrementalBackupOrFallbackToFull(BACKUP_HOST, 56789, this.backupDir, ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
            Assert.fail((String)"No exception thrown");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"BackupClient could not connect"));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectException.class));
        }
    }

    @Test
    public void shouldThrowUsefulMessageWhenCannotConnectDuringIncrementalBackup() throws Exception {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        BackupService backupService = this.backupService();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        try {
            this.backupService().doIncrementalBackupOrFallbackToFull(BACKUP_HOST, 56789, this.backupDir, ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
            Assert.fail((String)"No exception thrown");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"BackupClient could not connect"));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectException.class));
        }
    }

    @Test
    public void shouldThrowExceptionWhenDoingFullBackupWhenDirectoryHasSomeFiles() throws Exception {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        Assert.assertTrue((boolean)new File(this.backupDir, ".jibberishfile").createNewFile());
        try {
            this.backupService().doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.FULL, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not empty"));
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void shouldThrowExceptionWhenDoingFullBackupWhenDirectoryHasSomeDirs() throws Exception {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        Assert.assertTrue((boolean)new File(this.backupDir, "jibberishfolder").mkdir());
        try {
            this.backupService().doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.FULL, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not empty"));
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void shouldRemoveTempDirectory() throws Throwable {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        BackupService backupService = this.backupService();
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertFalse((String)"Temp directory was not removed as expected", (boolean)this.fileSystem.fileExists(new File(this.backupDir, "temp-copy")));
    }

    @Test
    public void shouldCopyStoreFiles() throws Throwable {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        BackupService backupService = this.backupService();
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        File[] files = this.fileSystem.listFiles(this.backupDir);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (StoreFile storeFile : StoreFile.values()) {
            if (storeFile == StoreFile.COUNTS_STORE_LEFT || storeFile == StoreFile.COUNTS_STORE_RIGHT) {
                MatcherAssert.assertThat((Object)files, (Matcher)CoreMatchers.anyOf(this.hasFile(StoreFile.COUNTS_STORE_LEFT.storeFileName()), this.hasFile(StoreFile.COUNTS_STORE_RIGHT.storeFileName())));
                continue;
            }
            MatcherAssert.assertThat((Object)files, this.hasFile(storeFile.storeFileName()));
        }
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void incrementallyBackupDatabaseShouldNotKeepGeneratedIdFiles() {
        int i;
        Node node;
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI graphDatabase = this.dbRule.getGraphDatabaseAPI();
        Label markerLabel = Label.label((String)"marker");
        try (Transaction transaction = graphDatabase.beginTx();){
            node = graphDatabase.createNode();
            node.addLabel(markerLabel);
            transaction.success();
        }
        transaction = graphDatabase.beginTx();
        var4_4 = null;
        try {
            node = this.findNodeByLabel(graphDatabase, markerLabel);
            for (i = 0; i < 10; ++i) {
                node.setProperty("property" + i, (Object)("testValue" + i));
            }
            transaction.success();
        }
        catch (Throwable node2) {
            var4_4 = node2;
            throw node2;
        }
        finally {
            if (transaction != null) {
                if (var4_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable node2) {
                        var4_4.addSuppressed(node2);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        this.doIncrementalBackupOrFallbackToFull();
        transaction = graphDatabase.beginTx();
        var4_4 = null;
        try {
            node = this.findNodeByLabel(graphDatabase, markerLabel);
            for (i = 0; i < 6; ++i) {
                node.removeProperty("property" + i);
            }
            transaction.success();
        }
        catch (Throwable node3) {
            var4_4 = node3;
            throw node3;
        }
        finally {
            if (transaction != null) {
                if (var4_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable node3) {
                        var4_4.addSuppressed(node3);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        this.doIncrementalBackupOrFallbackToFull();
        transaction = graphDatabase.beginTx();
        var4_4 = null;
        try {
            node = this.findNodeByLabel(graphDatabase, markerLabel);
            for (i = 10; i < 16; ++i) {
                node.setProperty("property" + i, (Object)("updatedValue" + i));
            }
            transaction.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var4_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        this.doIncrementalBackupOrFallbackToFull();
        GraphDatabaseService backupBasedDatabase = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.backupDir.getAbsoluteFile()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        try {
            Node node4;
            try (Transaction transaction = backupBasedDatabase.beginTx();){
                node4 = this.findNodeByLabel((GraphDatabaseAPI)backupBasedDatabase, markerLabel);
                Iterable propertyKeys = node4.getPropertyKeys();
                for (String propertyKey : propertyKeys) {
                    node4.setProperty(propertyKey, (Object)("updatedClientValue" + propertyKey));
                }
                node4.setProperty("newProperty", (Object)"updatedClientValue");
                transaction.success();
            }
            var5_5 = null;
            try (Transaction ignored = backupBasedDatabase.beginTx();){
                node4 = this.findNodeByLabel((GraphDatabaseAPI)backupBasedDatabase, markerLabel);
                Assert.assertEquals((String)"We should be able to see all previously defined properties.", (long)11L, (long)Iterables.asList((Iterable)node4.getPropertyKeys()).size());
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
        finally {
            backupBasedDatabase.shutdown();
        }
    }

    @Test
    public void shouldBeAbleToBackupEvenIfTransactionLogsAreIncomplete() throws Throwable {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        for (int i = 0; i < 100; ++i) {
            this.createAndIndexNode((GraphDatabaseService)db, i);
        }
        File oldLog = ((LogFile)db.getDependencyResolver().resolveDependency(LogFile.class)).currentLogFile();
        this.rotateAndCheckPoint(db);
        for (int i = 0; i < 1; ++i) {
            this.createAndIndexNode((GraphDatabaseService)db, i);
        }
        this.rotateAndCheckPoint(db);
        long lastCommittedTxBefore = ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
        db = this.dbRule.restartDatabase((fs, storeDirectory) -> FileUtils.deleteFile((File)oldLog), new String[0]);
        long lastCommittedTxAfter = ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
        BackupService backupService = this.backupService();
        BackupService.BackupOutcome outcome = backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.FULL, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertEquals((long)lastCommittedTxBefore, (long)lastCommittedTxAfter);
        Assert.assertTrue((boolean)outcome.isConsistent());
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
    }

    @Test
    public void shouldFindTransactionLogContainingLastNeoStoreTransactionInAnEmptyStore() throws IOException {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        BackupService backupService = this.backupService();
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
        Assert.assertEquals((long)0L, (long)this.getLastTxChecksum(this.pageCacheRule.getPageCache(this.fileSystem)));
    }

    @Test
    public void shouldFindTransactionLogContainingLastNeoStoreTransaction() throws Throwable {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        BackupService backupService = this.backupService();
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
        Assert.assertNotEquals((long)0L, (long)this.getLastTxChecksum(this.pageCacheRule.getPageCache(this.fileSystem)));
    }

    @Test
    public void shouldFindValidPreviousCommittedTxIdInFirstNeoStoreLog() throws Throwable {
        this.defaultBackupPortHostParams();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        this.createAndIndexNode((GraphDatabaseService)db, 2);
        this.createAndIndexNode((GraphDatabaseService)db, 3);
        this.createAndIndexNode((GraphDatabaseService)db, 4);
        ((StorageEngine)db.getDependencyResolver().resolveDependency(StorageEngine.class)).flushAndForce(this.limiter);
        long txId = ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
        BackupService backupService = this.backupService();
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, this.dbRule.getConfigCopy(), BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        this.checkPreviousCommittedTxIdFromLog(0L, 1L);
    }

    @Test
    public void shouldFindTransactionLogContainingLastLuceneTransaction() throws Throwable {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        BackupService backupService = this.backupService();
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
        Assert.assertNotEquals((long)0L, (long)this.getLastTxChecksum(this.pageCacheRule.getPageCache(this.fileSystem)));
    }

    @Test
    public void shouldGiveHelpfulErrorMessageIfLogsPrunedPastThePointOfNoReturn() throws Exception {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        this.dbRule.setConfig(GraphDatabaseSettings.keep_logical_logs, "false");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        BackupService backupService = this.backupService();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        this.rotateAndCheckPoint(db);
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        this.createAndIndexNode((GraphDatabaseService)db, 2);
        this.rotateAndCheckPoint(db);
        this.createAndIndexNode((GraphDatabaseService)db, 3);
        this.rotateAndCheckPoint(db);
        this.createAndIndexNode((GraphDatabaseService)db, 4);
        this.rotateAndCheckPoint(db);
        this.createAndIndexNode((GraphDatabaseService)db, 5);
        this.rotateAndCheckPoint(db);
        try {
            backupService.doIncrementalBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, BackupClient.BIG_READ_TIMEOUT, defaultConfig);
            Assert.fail((String)"Should have thrown exception.");
        }
        catch (IncrementalBackupNotPossibleException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)BackupService.TOO_OLD_BACKUP));
        }
    }

    @Test
    public void shouldFallbackToFullBackupIfIncrementalFailsAndExplicitlyAskedToDoThis() throws Exception {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        this.dbRule.setConfig(GraphDatabaseSettings.keep_logical_logs, "false");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        BackupService backupService = this.backupService();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        this.createAndIndexNode((GraphDatabaseService)db, 2);
        this.rotateAndCheckPoint(db);
        this.createAndIndexNode((GraphDatabaseService)db, 3);
        this.rotateAndCheckPoint(db);
        this.createAndIndexNode((GraphDatabaseService)db, 4);
        this.rotateAndCheckPoint(db);
        backupService.doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
    }

    private void rotateAndCheckPoint(GraphDatabaseAPI db) throws IOException {
        ((LogRotation)db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
        ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    @Test
    public void shouldHandleBackupWhenLogFilesHaveBeenDeleted() throws Exception {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        this.dbRule.setConfig(GraphDatabaseSettings.keep_logical_logs, "false");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        BackupService backupService = this.backupService();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        backupService.doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        this.createAndIndexNode((GraphDatabaseService)db, 2);
        db = this.deleteLogFilesAndRestart();
        this.createAndIndexNode((GraphDatabaseService)db, 3);
        db = this.deleteLogFilesAndRestart();
        backupService.doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
    }

    private GraphDatabaseAPI deleteLogFilesAndRestart() throws IOException {
        FileFilter logFileFilter = pathname -> pathname.getName().contains("logical");
        return this.dbRule.restartDatabase((fs, storeDirectory) -> {
            for (File logFile : this.storeDir.listFiles(logFileFilter)) {
                logFile.delete();
            }
        }, new String[0]);
    }

    @Test
    public void shouldDoFullBackupOnIncrementalFallbackToFullIfNoBackupFolderExists() throws Exception {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        this.dbRule.setConfig(GraphDatabaseSettings.keep_logical_logs, "false");
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        BackupService backupService = this.backupService();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        backupService.doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        db.shutdown();
        Assert.assertEquals((Object)this.getDbRepresentation(), (Object)this.getBackupDbRepresentation());
    }

    @Test
    public void shouldContainTransactionsThatHappenDuringBackupProcess() throws Throwable {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        this.dbRule.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
        Config withOnlineBackupDisabled = this.dbRule.getConfigCopy();
        Barrier.Control barrier = new Barrier.Control();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db, 1);
        DependencyResolver resolver = db.getDependencyResolver();
        long expectedLastTxId = ((TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        this.monitors.addMonitorListener((Object)new StoreSnoopingMonitor((Barrier)barrier), new String[0]);
        Dependencies dependencies = new Dependencies(resolver);
        dependencies.satisfyDependencies(new Object[]{defaultConfig, this.monitors, NullLogProvider.getInstance()});
        OnlineBackupKernelExtension backup = (OnlineBackupKernelExtension)new OnlineBackupExtensionFactory().newInstance((KernelContext)new SimpleKernelContext(this.storeDir, DatabaseInfo.UNKNOWN, (DependencySatisfier)dependencies), (OnlineBackupExtensionFactory.Dependencies)DependenciesProxy.dependencies((DependencyResolver)dependencies, OnlineBackupExtensionFactory.Dependencies.class));
        backup.start();
        BackupService backupService = this.backupService();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            barrier.awaitUninterruptibly();
            this.createAndIndexNode((GraphDatabaseService)db, 1);
            ((StorageEngine)resolver.resolveDependency(StorageEngine.class)).flushAndForce(this.limiter);
            barrier.release();
        });
        BackupService.BackupOutcome backupOutcome = backupService.doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.FULL, withOnlineBackupDisabled, BackupClient.BIG_READ_TIMEOUT, false);
        backup.stop();
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        this.checkPreviousCommittedTxIdFromLog(0L, expectedLastTxId);
        File neoStore = new File(this.storeDir, "neostore");
        long txIdFromOrigin = MetaDataStore.getRecord((PageCache)((PageCache)resolver.resolveDependency(PageCache.class)), (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID);
        this.checkLastCommittedTxIdInLogAndNeoStore(expectedLastTxId + 1L, txIdFromOrigin);
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)db), (Object)this.getBackupDbRepresentation());
        Assert.assertTrue((boolean)backupOutcome.isConsistent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void backupsShouldBeMentionedInServerConsoleLog() throws Throwable {
        this.defaultBackupPortHostParams();
        Config config = this.dbRule.getConfigCopy();
        this.dbRule.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
        Config withOnlineBackupDisabled = this.dbRule.getConfigCopy();
        this.createAndIndexNode((GraphDatabaseService)this.dbRule, 1);
        final Log log = (Log)Mockito.mock(Log.class);
        LogProvider logProvider = new LogProvider(){

            public Log getLog(Class loggingClass) {
                return log;
            }

            public Log getLog(String name) {
                return log;
            }
        };
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)log.infoLogger()).thenReturn((Object)logger);
        LogService logService = (LogService)Mockito.mock(LogService.class);
        Mockito.when((Object)logService.getInternalLogProvider()).thenReturn((Object)logProvider);
        Dependencies dependencies = new Dependencies(this.dbRule.getDependencyResolver());
        dependencies.satisfyDependencies(new Object[]{config, this.monitors, logService});
        OnlineBackupKernelExtension backup = (OnlineBackupKernelExtension)new OnlineBackupExtensionFactory().newInstance((KernelContext)new SimpleKernelContext(this.storeDir, DatabaseInfo.UNKNOWN, (DependencySatisfier)dependencies), (OnlineBackupExtensionFactory.Dependencies)DependenciesProxy.dependencies((DependencyResolver)dependencies, OnlineBackupExtensionFactory.Dependencies.class));
        try {
            backup.start();
            this.backupService().doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, withOnlineBackupDisabled, BackupClient.BIG_READ_TIMEOUT, false);
            ((Logger)Mockito.verify((Object)logger)).log((String)Matchers.eq((Object)"%s: Full backup started..."), new Object[]{Mockito.startsWith((String)"BackupServer")});
            ((Logger)Mockito.verify((Object)logger)).log((String)Matchers.eq((Object)"%s: Full backup finished."), new Object[]{Mockito.startsWith((String)"BackupServer")});
            this.createAndIndexNode((GraphDatabaseService)this.dbRule, 2);
            this.backupService().doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, withOnlineBackupDisabled, BackupClient.BIG_READ_TIMEOUT, false);
            ((Logger)Mockito.verify((Object)logger)).log((String)Matchers.eq((Object)"%s: Incremental backup started..."), new Object[]{Mockito.startsWith((String)"BackupServer")});
            ((Logger)Mockito.verify((Object)logger)).log((String)Matchers.eq((Object)"%s: Incremental backup finished."), new Object[]{Mockito.startsWith((String)"BackupServer")});
        }
        finally {
            backup.stop();
        }
    }

    @Test
    public void incrementalBackupShouldFailWhenTargetDirContainsDifferentStore() throws IOException {
        this.defaultBackupPortHostParams();
        Config defaultConfig = this.dbRule.getConfigCopy();
        GraphDatabaseAPI db1 = this.dbRule.getGraphDatabaseAPI();
        this.createAndIndexNode((GraphDatabaseService)db1, 1);
        this.backupService().doFullBackup(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
        GraphDatabaseAPI db2 = this.dbRule.restartDatabase((fs, storeDirectory) -> {
            this.deleteAllBackedUpTransactionLogs();
            this.fileSystem.deleteRecursively(this.storeDir);
            this.fileSystem.mkdir(this.storeDir);
        }, new String[0]);
        this.createAndIndexNode((GraphDatabaseService)db2, 2);
        try {
            this.backupService().doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir.getAbsoluteFile(), ConsistencyCheck.NONE, defaultConfig, BackupClient.BIG_READ_TIMEOUT, false);
            Assert.fail((String)"Should have thrown exception about mismatching store ids");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Target directory contains full backup of a logically different store."));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(MismatchingStoreIdException.class));
        }
    }

    private void defaultBackupPortHostParams() {
        this.dbRule.setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + this.backupPort);
    }

    private void createAndIndexNode(GraphDatabaseService db, int i) {
        try (Transaction tx = db.beginTx();){
            Index index = db.index().forNodes("delete_me");
            Node node = db.createNode();
            node.setProperty("id", (Object)(System.currentTimeMillis() + (long)i));
            index.add((PropertyContainer)node, "delete", (Object)"me");
            tx.success();
        }
    }

    private BaseMatcher<File[]> hasFile(final String fileName) {
        return new BaseMatcher<File[]>(){

            public boolean matches(Object o) {
                File[] files = (File[])o;
                if (files == null) {
                    return false;
                }
                for (File file : files) {
                    if (!file.getAbsolutePath().contains(fileName)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("[%s] in list of copied files", fileName));
            }
        };
    }

    private void checkPreviousCommittedTxIdFromLog(long logVersion, long txId) throws IOException {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.backupDir, this.fileSystem);
        LogHeader logHeader = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (File)logFiles.getLogFileForVersion(logVersion));
        Assert.assertEquals((long)txId, (long)logHeader.lastCommittedTxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLastCommittedTxIdInLogAndNeoStore(long txId, long txIdFromOrigin) throws Exception {
        LifeSupport life = new LifeSupport();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        LogicalTransactionStore transactionStore = (LogicalTransactionStore)life.add((Lifecycle)new ReadOnlyTransactionStore(pageCache, this.fileSystem, this.backupDir, this.monitors));
        life.start();
        try (TransactionCursor cursor = transactionStore.getTransactions(txId);){
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)txId, (long)((CommittedTransactionRepresentation)cursor.get()).getCommitEntry().getTxId());
            Assert.assertFalse((boolean)cursor.next());
        }
        finally {
            life.shutdown();
        }
        Assert.assertEquals((long)txId, (long)txIdFromOrigin);
    }

    private long getLastTxChecksum(PageCache pageCache) throws IOException {
        File neoStore = new File(this.backupDir, "neostore");
        return MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
    }

    private void deleteAllBackedUpTransactionLogs() {
        for (File log : this.fileSystem.listFiles(this.backupDir, LogFiles.FILENAME_FILTER)) {
            this.fileSystem.deleteFile(log);
        }
    }

    private void doIncrementalBackupOrFallbackToFull() {
        BackupService backupService = this.backupService();
        backupService.doIncrementalBackupOrFallbackToFull(BACKUP_HOST, this.backupPort, this.backupDir, ConsistencyCheck.NONE, Config.defaults(), BackupClient.BIG_READ_TIMEOUT, false);
    }

    private Node findNodeByLabel(GraphDatabaseAPI graphDatabase, Label label) {
        try (ResourceIterator nodes = graphDatabase.findNodes(label);){
            Node node = (Node)nodes.next();
            return node;
        }
    }

    private DbRepresentation getBackupDbRepresentation() {
        return DbRepresentation.of((File)this.backupDir, (Config)Config.defaults((Setting)OnlineBackupSettings.online_backup_enabled, (String)"false"));
    }

    private DbRepresentation getDbRepresentation() {
        return DbRepresentation.of((File)this.storeDir, (Config)Config.defaults((Setting)OnlineBackupSettings.online_backup_enabled, (String)"false"));
    }

    private static class TestFullConsistencyCheck
    implements ConsistencyCheck {
        private boolean checked;

        private TestFullConsistencyCheck() {
        }

        public String name() {
            return "testFull";
        }

        public boolean runFull(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose, CheckConsistencyConfig checkConsistencyConfig) throws ConsistencyCheckFailedException {
            this.markAsChecked();
            return ConsistencyCheck.FULL.runFull(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose, checkConsistencyConfig);
        }

        private void markAsChecked() {
            this.checked = true;
        }

        boolean isChecked() {
            return this.checked;
        }
    }

    private static final class StoreSnoopingMonitor
    extends StoreCopyServer.Monitor.Adapter {
        private final Barrier barrier;

        private StoreSnoopingMonitor(Barrier barrier) {
            this.barrier = barrier;
        }

        public void finishStreamingStoreFile(File storefile, String storeCopyIdentifier) {
            if (storefile.getAbsolutePath().contains(BackupServiceIT.NODE_STORE) || storefile.getAbsolutePath().contains(BackupServiceIT.RELATIONSHIP_STORE)) {
                this.barrier.reached();
            }
        }
    }
}

