/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.backup.EmbeddedServer;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.backup.ServerInterface;
import org.neo4j.com.ports.allocation.PortAuthority;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class IncrementalBackupIT {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private File serverPath;
    private File backupPath;
    private ServerInterface server;
    private GraphDatabaseService db;

    @Before
    public void before() throws Exception {
        File base = this.testDirectory.directory(this.testName.getMethodName());
        this.serverPath = new File(base, "server");
        this.backupPath = new File(base, "backup");
    }

    @After
    public void shutItDown() throws Exception {
        if (this.server != null) {
            this.shutdownServer(this.server);
            this.server = null;
        }
        if (this.db != null) {
            this.db.shutdown();
            this.db = null;
        }
    }

    @Test
    public void shouldDoIncrementalBackup() throws Exception {
        DbRepresentation initialDataSetRepresentation = this.createInitialDataSet(this.serverPath);
        int port = PortAuthority.allocatePort();
        this.server = this.startServer(this.serverPath, "127.0.0.1:" + port);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)port);
        backup.full(this.backupPath.getPath());
        Assert.assertEquals((Object)initialDataSetRepresentation, (Object)this.getBackupDbRepresentation());
        this.shutdownServer(this.server);
        DbRepresentation furtherRepresentation = this.addMoreData2(this.serverPath);
        this.server = this.startServer(this.serverPath, "127.0.0.1:" + port);
        backup.incremental(this.backupPath.getPath());
        Assert.assertEquals((Object)furtherRepresentation, (Object)this.getBackupDbRepresentation());
        this.shutdownServer(this.server);
    }

    @Test
    public void shouldNotServeTransactionsWithInvalidHighIds() throws Exception {
        DbRepresentation initialDataSetRepresentation = this.createInitialDataSet(this.serverPath);
        int port = PortAuthority.allocatePort();
        this.server = this.startServer(this.serverPath, "127.0.0.1:" + port);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)port);
        backup.full(this.backupPath.getPath());
        Assert.assertEquals((Object)initialDataSetRepresentation, (Object)this.getBackupDbRepresentation());
        this.shutdownServer(this.server);
        DbRepresentation furtherRepresentation = this.createTransactiongWithWeirdRelationshipGroupRecord(this.serverPath);
        this.server = this.startServer(this.serverPath, "127.0.0.1:" + port);
        backup.incremental(this.backupPath.getPath());
        Assert.assertEquals((Object)furtherRepresentation, (Object)this.getBackupDbRepresentation());
        this.shutdownServer(this.server);
    }

    private DbRepresentation createInitialDataSet(File path) {
        this.db = this.startGraphDatabase(path);
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode().setProperty("name", (Object)"Goofy");
            Node donald = this.db.createNode();
            donald.setProperty("name", (Object)"Donald");
            Node daisy = this.db.createNode();
            daisy.setProperty("name", (Object)"Daisy");
            Relationship knows = donald.createRelationshipTo(daisy, RelationshipType.withName((String)"LOVES"));
            knows.setProperty("since", (Object)1940);
            tx.success();
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)this.db);
        this.db.shutdown();
        return result;
    }

    private DbRepresentation addMoreData2(File path) {
        this.db = this.startGraphDatabase(path);
        try (Transaction tx = this.db.beginTx();){
            Node donald = this.db.getNodeById(2L);
            Node gladstone = this.db.createNode();
            gladstone.setProperty("name", (Object)"Gladstone");
            Relationship hates = donald.createRelationshipTo(gladstone, RelationshipType.withName((String)"HATES"));
            hates.setProperty("since", (Object)1948);
            tx.success();
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)this.db);
        this.db.shutdown();
        return result;
    }

    private DbRepresentation createTransactiongWithWeirdRelationshipGroupRecord(File path) {
        Node node;
        this.db = this.startGraphDatabase(path);
        DynamicRelationshipType typeToDelete = DynamicRelationshipType.withName((String)"A");
        DynamicRelationshipType theOtherType = DynamicRelationshipType.withName((String)"B");
        int defaultDenseNodeThreshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            for (int i = 0; i < defaultDenseNodeThreshold - 1; ++i) {
                node.createRelationshipTo(this.db.createNode(), (RelationshipType)theOtherType);
            }
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)typeToDelete);
            tx.success();
        }
        tx = this.db.beginTx();
        var8_7 = null;
        try {
            node.createRelationshipTo(this.db.createNode(), (RelationshipType)theOtherType);
            for (Relationship relationship : node.getRelationships(Direction.BOTH, new RelationshipType[]{typeToDelete})) {
                relationship.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)this.db);
        this.db.shutdown();
        return result;
    }

    private GraphDatabaseService startGraphDatabase(File path) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(path).setConfig(OnlineBackupSettings.online_backup_enabled, "false").setConfig(GraphDatabaseSettings.keep_logical_logs, "true").newGraphDatabase();
    }

    private ServerInterface startServer(File path, String serverAddress) throws Exception {
        EmbeddedServer server = new EmbeddedServer(path, serverAddress);
        server.awaitStarted();
        return server;
    }

    private void shutdownServer(ServerInterface server) throws Exception {
        server.shutdown();
        Thread.sleep(1000L);
    }

    private DbRepresentation getBackupDbRepresentation() {
        return DbRepresentation.of((File)this.backupPath, (Config)Config.defaults((Setting)OnlineBackupSettings.online_backup_enabled, (String)"false"));
    }
}

