/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.neo4j.backup.ServerInterface;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.subprocess.SubProcess;

public class ServerProcess
extends SubProcess<ServerInterface, Pair<File, String>>
implements ServerInterface {
    private volatile transient GraphDatabaseService db;

    public void startup(Pair<File, String> config) throws Throwable {
        File storeDir = (File)config.first();
        String backupConfigValue = (String)config.other();
        this.db = backupConfigValue == null ? new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir) : new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig("enable_online_backup", backupConfigValue).newGraphDatabase();
    }

    @Override
    public void awaitStarted() {
        while (this.db == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public void shutdown(boolean normal) {
        this.db.shutdown();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                ServerProcess.this.shutdownProcess();
            }
        }.start();
    }

    protected void shutdownProcess() {
        super.shutdown();
    }
}

