/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.com.ports.allocation.PortAuthority;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;

public class TestConfiguration {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private static final File SOURCE_DIR = new File("target/db");
    private static final String BACKUP_DIR = "target/full-backup";
    private static final String HOST_ADDRESS = "127.0.0.1";

    @Before
    public void before() throws Exception {
        FileUtils.deleteDirectory((File)SOURCE_DIR);
        FileUtils.deleteDirectory((File)new File(BACKUP_DIR));
    }

    @Test
    public void testOnByDefault() throws Exception {
        int port = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(SOURCE_DIR).setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + port).newGraphDatabase();
        OnlineBackup.from((String)HOST_ADDRESS, (int)port).full(BACKUP_DIR);
        db.shutdown();
    }

    @Test
    public void testOffByConfig() throws Exception {
        int port = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(SOURCE_DIR).setConfig(OnlineBackupSettings.online_backup_enabled, "false").setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + port).newGraphDatabase();
        try {
            OnlineBackup.from((String)HOST_ADDRESS, (int)port).full(BACKUP_DIR);
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        db.shutdown();
    }

    @Test
    public void testEnableDefaultsInConfig() throws Exception {
        int port = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(SOURCE_DIR).setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + port).newGraphDatabase();
        OnlineBackup.from((String)HOST_ADDRESS, (int)port).full(BACKUP_DIR);
        db.shutdown();
    }

    @Test
    public void testEnableCustomPortInConfig() throws Exception {
        int customPort = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(SOURCE_DIR).setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, ":" + customPort).newGraphDatabase();
        try {
            OnlineBackup.from((String)HOST_ADDRESS, (int)PortAuthority.allocatePort()).full(BACKUP_DIR);
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OnlineBackup.from((String)HOST_ADDRESS, (int)customPort).full(BACKUP_DIR);
        db.shutdown();
    }
}

