/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.restore;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.com.ports.allocation.PortAuthority;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.locker.StoreLocker;
import org.neo4j.restore.RestoreDatabaseCliProvider;
import org.neo4j.restore.RestoreDatabaseCommand;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RestoreDatabaseCommandIT {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void forceShouldRespectStoreLock() throws Exception {
        String databaseName = "to";
        Config config = RestoreDatabaseCommandIT.configWith(databaseName, this.directory.absolutePath().getAbsolutePath());
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        int fromNodeCount = 10;
        int toNodeCount = 20;
        this.createDbAt(fromPath, fromNodeCount);
        this.createDbAt(toPath, toNodeCount);
        FileSystemAbstraction fs = this.fileSystemRule.get();
        try (StoreLocker storeLocker = new StoreLocker(fs, toPath);){
            storeLocker.checkLock();
            new RestoreDatabaseCommand(fs, fromPath, config, databaseName, true).execute();
            Assert.fail((String)"expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"the database is in use -- stop Neo4j and try again"));
        }
    }

    @Test
    public void shouldNotCopyOverAndExistingDatabase() throws Exception {
        String databaseName = "to";
        Config config = RestoreDatabaseCommandIT.configWith(databaseName, this.directory.absolutePath().getAbsolutePath());
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        this.createDbAt(fromPath, 0);
        this.createDbAt(toPath, 0);
        try {
            new RestoreDatabaseCommand(this.fileSystemRule.get(), fromPath, config, databaseName, false).execute();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Database with name [to] already exists"));
        }
    }

    @Test
    public void shouldThrowExceptionIfBackupDirectoryDoesNotExist() throws Exception {
        String databaseName = "to";
        Config config = RestoreDatabaseCommandIT.configWith(databaseName, this.directory.absolutePath().getAbsolutePath());
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        this.createDbAt(toPath, 0);
        try {
            new RestoreDatabaseCommand(this.fileSystemRule.get(), fromPath, config, databaseName, false).execute();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException exception) {
            Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Source directory does not exist"));
        }
    }

    @Test
    public void shouldAllowForcedCopyOverAnExistingDatabase() throws Exception {
        String databaseName = "to";
        Config config = RestoreDatabaseCommandIT.configWith(databaseName, this.directory.absolutePath().getAbsolutePath());
        File fromPath = new File(this.directory.absolutePath(), "from");
        File toPath = (File)config.get(DatabaseManagementSystemSettings.database_path);
        int fromNodeCount = 10;
        int toNodeCount = 20;
        this.createDbAt(fromPath, fromNodeCount);
        this.createDbAt(toPath, toNodeCount);
        new RestoreDatabaseCommand(this.fileSystemRule.get(), fromPath, config, databaseName, true).execute();
        GraphDatabaseService copiedDb = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(toPath).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        try (Transaction ignored = copiedDb.beginTx();){
            Assert.assertEquals((long)fromNodeCount, (long)Iterables.count((Iterable)copiedDb.getAllNodes()));
        }
        copiedDb.shutdown();
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new RestoreDatabaseCliProvider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin restore --from=<backup-directory> [--database=<name>]%n                           [--force[=<true|false>]]%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set size of JVM heap during command execution.%n                  Takes a number and a unit, for example 512m.%n%nRestore a backed up database.%n%noptions:%n  --from=<backup-directory>   Path to backup to restore from.%n  --database=<name>           Name of database. [default:graph.db]%n  --force=<true|false>        If an existing database should be replaced.%n                              [default:false]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private static Config configWith(String databaseName, String dataDirectory) {
        return Config.defaults((Map)MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName, DatabaseManagementSystemSettings.data_directory.name(), dataDirectory}));
    }

    private void createDbAt(File fromPath, int nodesToCreate) {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseService db = factory.newEmbeddedDatabaseBuilder(fromPath).setConfig(OnlineBackupSettings.online_backup_server, "127.0.0.1:" + PortAuthority.allocatePort()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < nodesToCreate; ++i) {
                db.createNode();
            }
            tx.success();
        }
        db.shutdown();
    }
}

