/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import java.util.stream.LongStream;
import org.eclipse.collections.api.factory.Sets;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.internal.BatchRelationship;
import org.neo4j.batchinsert.internal.BatchRelationshipIterable;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.DegreesRebuildFromStore;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.internal.counts.GBPTreeRelationshipGroupDegreesStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.IteratorWrapper;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.recordstorage.DirectRecordAccessSet;
import org.neo4j.internal.recordstorage.PropertyCreator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.recordstorage.SchemaCache;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.locker.DatabaseLocker;
import org.neo4j.kernel.internal.locker.Locker;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.time.Clocks;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class BatchInserterImpl
implements BatchInserter {
    private static final String BATCH_INSERTER_TAG = "batchInserter";
    private static final String CHECKPOINT_REASON = "Batch inserter checkpoint.";
    private final LifeSupport life;
    private final NeoStores neoStores;
    private final DatabaseLayout databaseLayout;
    private final TokenHolders tokenHolders;
    private final IdGeneratorFactory idGeneratorFactory;
    private final IndexProviderMap indexProviderMap;
    private final Log msgLog;
    private final SchemaCache schemaCache;
    private final Config config;
    private final BatchSchemaActions actions;
    private final Locker locker;
    private final PageCache pageCache;
    private final RecordStorageReader storageReader;
    private final SimpleLogService logService;
    private final FileSystemAbstraction fileSystem;
    private final Monitors monitors;
    private final JobScheduler jobScheduler;
    private final SchemaRuleAccess schemaRuleAccess;
    private final PageCacheTracer pageCacheTracer;
    private final CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private final RelationshipGroupDegreesStore.Updater degreeUpdater;
    private final RelationshipGroupGetter relationshipGroupGetter;
    private boolean isShutdown;
    private final LongFunction<Label> labelIdToLabelFunction;
    private final FlushStrategy flushStrategy;
    private final RelationshipCreator relationshipCreator;
    private final DirectRecordAccessSet recordAccess;
    private final PropertyTraverser propertyTraverser;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeletor;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final PropertyStore propertyStore;
    private final SchemaStore schemaStore;
    private final GBPTreeRelationshipGroupDegreesStore groupDegreesStore;
    private final FullScanStoreView fullScanStoreView;
    private final LabelTokenStore labelTokenStore;
    private final long maxNodeId;
    private final DatabaseReadOnlyChecker readOnlyChecker;

    public BatchInserterImpl(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, Config fromConfig, Iterable<ExtensionFactory<?>> extensions, DatabaseTracers tracers) throws IOException {
        BatchInserterImpl.rejectAutoUpgrade(fromConfig);
        Neo4jLayout layout = databaseLayout.getNeo4jLayout();
        this.config = Config.newBuilder().setDefaults(BatchInserterImpl.getDefaultParams()).set(GraphDatabaseSettings.neo4j_home, (Object)layout.homeDirectory()).set(GraphDatabaseInternalSettings.databases_root_path, (Object)layout.databasesDirectory()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)layout.transactionLogsRootDirectory()).set(GraphDatabaseSettings.logs_directory, (Object)Path.of("", new String[0])).fromConfig(fromConfig).build();
        this.fileSystem = fileSystem;
        this.pageCacheTracer = tracers.getPageCacheTracer();
        this.cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(BATCH_INSERTER_TAG));
        this.memoryTracker = EmptyMemoryTracker.INSTANCE;
        this.life = new LifeSupport();
        this.databaseLayout = databaseLayout;
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        try {
            this.life.add((Lifecycle)this.jobScheduler);
            this.locker = BatchInserterImpl.tryLockStore(fileSystem, databaseLayout);
            ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, this.config, this.pageCacheTracer, (Log)NullLog.getInstance(), this.jobScheduler, Clocks.nanoClock(), new MemoryPools(((Boolean)this.config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
            this.pageCache = pageCacheFactory.getOrCreatePageCache();
            this.life.add((Lifecycle)new PageCacheLifecycle(this.pageCache));
            Neo4jLoggerContext ctx = LogConfig.createBuilder((FileSystemAbstraction)fileSystem, (Path)((Path)this.config.get(GraphDatabaseSettings.store_internal_log_path)), (Level)Level.INFO).build();
            this.logService = (SimpleLogService)this.life.add((Lifecycle)new SimpleLogService(ctx));
            this.msgLog = this.logService.getInternalLog(this.getClass());
            boolean dump = (Boolean)this.config.get(GraphDatabaseInternalSettings.dump_configuration);
            this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate(), true, databaseLayout.getDatabaseName());
            LogProvider internalLogProvider = this.logService.getInternalLogProvider();
            RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig((Config)this.config, (DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fileSystem, (PageCache)this.pageCache, (LogProvider)internalLogProvider, (PageCacheTracer)this.pageCacheTracer);
            this.readOnlyChecker = DatabaseReadOnlyChecker.writable();
            StoreFactory sf = new StoreFactory(this.databaseLayout, this.config, this.idGeneratorFactory, this.pageCache, fileSystem, recordFormats, internalLogProvider, this.pageCacheTracer, this.readOnlyChecker, Sets.immutable.empty());
            this.maxNodeId = recordFormats.node().getMaxId();
            if (dump) {
                BatchInserterImpl.dumpConfiguration(this.config);
            }
            this.msgLog.info(Thread.currentThread() + " Starting BatchInserter(" + this + ")");
            this.life.start();
            this.neoStores = sf.openAllNeoStores(true);
            this.neoStores.verifyStoreOk();
            this.neoStores.start(this.cursorContext);
            this.nodeStore = this.neoStores.getNodeStore();
            this.relationshipStore = this.neoStores.getRelationshipStore();
            this.relationshipTypeTokenStore = this.neoStores.getRelationshipTypeTokenStore();
            this.propertyKeyTokenStore = this.neoStores.getPropertyKeyTokenStore();
            this.propertyStore = this.neoStores.getPropertyStore();
            RelationshipGroupStore relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
            this.schemaStore = this.neoStores.getSchemaStore();
            this.labelTokenStore = this.neoStores.getLabelTokenStore();
            this.groupDegreesStore = new GBPTreeRelationshipGroupDegreesStore(this.pageCache, databaseLayout.relationshipGroupDegreesStore(), fileSystem, RecoveryCleanupWorkCollector.immediate(), (GBPTreeRelationshipGroupDegreesStore.DegreesRebuilder)new DegreesRebuildFromStore(this.pageCache, this.neoStores, databaseLayout, this.pageCacheTracer, this.logService.getInternalLogProvider(), Configuration.DEFAULT), this.readOnlyChecker, this.pageCacheTracer, GBPTreeGenericCountsStore.NO_MONITOR, databaseLayout.getDatabaseName(), ((Integer)this.config.get(GraphDatabaseInternalSettings.counts_store_max_cached_entries)).intValue(), this.logService.getInternalLogProvider());
            this.groupDegreesStore.start(this.cursorContext, this.memoryTracker);
            this.degreeUpdater = this.groupDegreesStore.directApply(this.cursorContext);
            DelegatingTokenHolder propertyKeyTokenHolder = new DelegatingTokenHolder(this::createNewPropertyKeyId, "PropertyKey");
            DelegatingTokenHolder relationshipTypeTokenHolder = new DelegatingTokenHolder(this::createNewRelationshipType, "RelationshipType");
            DelegatingTokenHolder labelTokenHolder = new DelegatingTokenHolder(this::createNewLabelId, "Label");
            this.tokenHolders = new TokenHolders((TokenHolder)propertyKeyTokenHolder, (TokenHolder)labelTokenHolder, (TokenHolder)relationshipTypeTokenHolder);
            this.tokenHolders.setInitialTokens(StoreTokens.allTokens((NeoStores)this.neoStores), this.cursorContext);
            this.labelIdToLabelFunction = from -> {
                try {
                    return Label.label((String)this.tokenHolders.labelTokens().getTokenById(Numbers.safeCastLongToInt((long)from)).name());
                }
                catch (TokenNotFoundException e) {
                    throw new RuntimeException(e);
                }
            };
            this.monitors = new Monitors();
            this.fullScanStoreView = new FullScanStoreView(LockService.NO_LOCK_SERVICE, () -> new RecordStorageReader(this.neoStores), this.config, this.jobScheduler);
            Dependencies deps = new Dependencies();
            deps.satisfyDependencies(new Object[]{fileSystem, this.jobScheduler, this.config, this.logService, this.fullScanStoreView, this.tokenHolders, this.pageCache, this.monitors, RecoveryCleanupWorkCollector.immediate(), this.pageCacheTracer, databaseLayout, this.readOnlyChecker});
            DatabaseExtensions databaseExtensions = (DatabaseExtensions)this.life.add((Lifecycle)new DatabaseExtensions(new DatabaseExtensionContext(this.databaseLayout, DbmsInfo.TOOL, (DependencySatisfier)deps), extensions, deps, ExtensionFailureStrategies.ignore()));
            this.indexProviderMap = (IndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)databaseExtensions, this.config));
            this.schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)this.schemaStore, (TokenHolders)this.tokenHolders, (KernelVersionRepository)this.neoStores.getMetaDataStore());
            this.schemaCache = new SchemaCache((ConstraintRuleAccessor)ConstraintSemantics.getConstraintSemantics(), (IndexConfigCompleter)this.indexProviderMap);
            this.schemaCache.load(this.schemaRuleAccess.getAll(this.cursorContext));
            this.actions = new BatchSchemaActions();
            this.recordAccess = new DirectRecordAccessSet(this.neoStores, this.idGeneratorFactory, this.cursorContext);
            this.relationshipGroupGetter = new RelationshipGroupGetter((IdSequence)relationshipGroupStore, this.cursorContext);
            this.relationshipCreator = new RelationshipCreator(relationshipGroupStore.getStoreHeaderInt(), 10L, this.cursorContext);
            this.propertyTraverser = new PropertyTraverser(this.cursorContext);
            this.propertyCreator = new PropertyCreator(this.propertyStore, this.propertyTraverser, this.cursorContext, this.memoryTracker);
            this.propertyDeletor = new PropertyDeleter(this.propertyTraverser, this.neoStores, (TokenNameLookup)this.tokenHolders, this.logService.getInternalLogProvider(), this.config, this.cursorContext, this.memoryTracker);
            this.flushStrategy = new BatchedFlushStrategy(this.recordAccess, (Integer)this.config.get(GraphDatabaseInternalSettings.batch_inserter_batch_size));
            this.storageReader = new RecordStorageReader(this.neoStores);
        }
        catch (Exception e) {
            try {
                this.jobScheduler.shutdown();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    private static Locker tryLockStore(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
        DatabaseLocker locker = new DatabaseLocker(fileSystem, databaseLayout);
        try {
            locker.checkLock();
        }
        catch (Exception e) {
            try {
                locker.close();
            }
            catch (IOException ce) {
                e.addSuppressed(ce);
            }
            throw e;
        }
        return locker;
    }

    private static Map<Setting<?>, Object> getDefaultParams() {
        HashMap params = new HashMap();
        params.put(GraphDatabaseSettings.pagecache_memory, "32m");
        return params;
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.primitiveHasProperty((PrimitiveRecord)this.getNodeRecord(node).forChangingData(), propertyName);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.primitiveHasProperty((PrimitiveRecord)this.recordAccess.getRelRecords().getOrLoad(relationship, null, this.cursorContext).forReadingData(), propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<NodeRecord, Void> nodeRecord = this.getNodeRecord(node);
        this.setPrimitiveProperty(nodeRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<RelationshipRecord, Void> relationshipRecord = this.getRelationshipRecord(relationship);
        this.setPrimitiveProperty(relationshipRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void removeNodeProperty(long node, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removePropertyIfExists(this.getNodeRecord(node), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public void removeRelationshipProperty(long relationship, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removePropertyIfExists(this.getRelationshipRecord(relationship), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public IndexCreator createDeferredSchemaIndex(Label label) {
        return new IndexCreatorImpl((InternalSchemaActions)this.actions, new Label[]{label});
    }

    private void setPrimitiveProperty(RecordAccess.RecordProxy<? extends PrimitiveRecord, Void> primitiveRecord, String propertyName, Object propertyValue) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        RecordAccess propertyRecords = this.recordAccess.getPropertyRecords();
        this.propertyCreator.primitiveSetProperty(primitiveRecord, propertyKey, ValueUtils.asValue((Object)propertyValue), propertyRecords);
    }

    private void validateIndexCanBeCreated(SchemaDescriptor schemaDescriptor) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(schemaDescriptor, "Index for given {label;property} already exists");
    }

    private void validateUniquenessConstraintCanBeCreated(LabelSchemaDescriptor schemaDescriptor) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated((SchemaDescriptor)schemaDescriptor, "It is not allowed to create node keys, uniqueness constraints or indexes on the same {label;property}");
    }

    private void validateNodeKeyConstraintCanBeCreated(LabelSchemaDescriptor schemaDescriptor) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated((SchemaDescriptor)schemaDescriptor, "It is not allowed to create node keys, uniqueness constraints or indexes on the same {label;property}");
    }

    private void verifyIndexOrUniquenessConstraintCanBeCreated(SchemaDescriptor schemaDescriptor, String errorMessage) {
        if (schemaDescriptor.isFulltextSchemaDescriptor()) {
            if (this.schemaCache.hasIndex(schemaDescriptor)) {
                throw new ConstraintViolationException(errorMessage);
            }
        } else {
            UniquenessConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schemaDescriptor);
            NodeKeyConstraintDescriptor nodeKeyDescriptor = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)schemaDescriptor);
            if (this.schemaCache.hasIndex(schemaDescriptor) || this.schemaCache.hasConstraintRule((ConstraintDescriptor)constraintDescriptor) || this.schemaCache.hasConstraintRule((ConstraintDescriptor)nodeKeyDescriptor)) {
                throw new ConstraintViolationException(errorMessage);
            }
        }
    }

    private void validateNodePropertyExistenceConstraintCanBeCreated(int labelId, int[] propertyKeyIds) {
        NodeExistenceConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])propertyKeyIds);
        if (this.schemaCache.hasConstraintRule((ConstraintDescriptor)constraintDescriptor)) {
            throw new ConstraintViolationException("Node property existence constraint for given {label;property} already exists");
        }
    }

    private void validateRelationshipConstraintCanBeCreated(int relTypeId, int propertyKeyId) {
        NodeExistenceConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.existsForLabel((int)relTypeId, (int[])new int[]{propertyKeyId});
        if (this.schemaCache.hasConstraintRule((ConstraintDescriptor)constraintDescriptor)) {
            throw new ConstraintViolationException("Relationship property existence constraint for given {type;property} already exists");
        }
    }

    private IndexDescriptor createIndex(IndexPrototype prototype) {
        IndexProvider provider = BatchInserterImpl.isFullTextIndexType(prototype) ? this.indexProviderMap.getFulltextProvider() : this.indexProviderMap.getDefaultProvider();
        IndexProviderDescriptor providerDescriptor = provider.getProviderDescriptor();
        prototype = prototype.withIndexProvider(providerDescriptor);
        prototype = this.ensureSchemaHasName(prototype);
        IndexDescriptor index = prototype.materialise(this.schemaStore.nextId(this.cursorContext));
        index = provider.completeConfiguration(index);
        try {
            this.schemaRuleAccess.writeSchemaRule((SchemaRule)index, this.cursorContext, this.memoryTracker);
            this.schemaCache.addSchemaRule((SchemaRule)index);
            this.flushStrategy.forceFlush();
            return index;
        }
        catch (KernelException e) {
            throw BatchInserterImpl.kernelExceptionToUserException(e);
        }
    }

    private static boolean isFullTextIndexType(IndexPrototype prototype) {
        return prototype.getIndexType() == IndexType.FULLTEXT;
    }

    private void repopulateAllIndexes() throws IOException {
        LogProvider logProvider = this.logService.getInternalLogProvider();
        LogProvider userLogProvider = this.logService.getUserLogProvider();
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory(this.config, () -> new RecordStorageReader(this.neoStores, this.schemaCache), Locks.NO_LOCKS, this.fullScanStoreView, LockService.NO_LOCK_SERVICE, logProvider);
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(this.pageCache, this.databaseLayout.indexStatisticsStore(), RecoveryCleanupWorkCollector.immediate(), this.readOnlyChecker, this.databaseLayout.getDatabaseName(), cacheTracer);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)this.config, (JobScheduler)this.jobScheduler, (IndexProviderMap)this.indexProviderMap, (IndexStoreViewFactory)indexStoreViewFactory, (TokenNameLookup)this.tokenHolders, Collections.emptyList(), (LogProvider)logProvider, (LogProvider)userLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)new DatabaseSchemaState(logProvider), (IndexStatisticsStore)indexStatisticsStore, (PageCacheTracer)cacheTracer, (MemoryTracker)this.memoryTracker, (String)this.databaseLayout.getDatabaseName(), (DatabaseReadOnlyChecker)this.readOnlyChecker);
        this.life.add((Lifecycle)indexingService);
        try {
            IndexDescriptor[] descriptors = this.getIndexesNeedingPopulation(this.cursorContext);
            indexingService.createIndexes(true, Subject.AUTH_DISABLED, descriptors);
            for (IndexDescriptor descriptor : descriptors) {
                IndexProxy indexProxy = BatchInserterImpl.getIndexProxy(indexingService, descriptor);
                try {
                    indexProxy.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
                }
                catch (IndexPopulationFailedKernelException indexPopulationFailedKernelException) {
                    // empty catch block
                }
            }
            indexingService.forceAll(this.cursorContext);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static IndexProxy getIndexProxy(IndexingService indexingService, IndexDescriptor index) {
        try {
            return indexingService.getIndexProxy(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Expected index by descriptor " + index + " to exist, but didn't", e);
        }
    }

    private void rebuildCounts(PageCacheTracer cacheTracer, MemoryTracker memoryTracker) throws IOException {
        Path countsStoreFile = this.databaseLayout.countStore();
        if (this.fileSystem.fileExists(countsStoreFile)) {
            this.fileSystem.deleteFile(countsStoreFile);
        }
        CountsComputer initialCountsBuilder = new CountsComputer(this.neoStores, this.pageCache, cacheTracer, this.databaseLayout, memoryTracker, this.logService.getInternalLog(this.getClass()));
        try (GBPTreeCountsStore countsStore = new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.immediate(), (CountsBuilder)initialCountsBuilder, this.readOnlyChecker, cacheTracer, GBPTreeGenericCountsStore.NO_MONITOR, this.databaseLayout.getDatabaseName(), ((Integer)this.config.get(GraphDatabaseInternalSettings.counts_store_max_cached_entries)).intValue());){
            countsStore.start(CursorContext.NULL, memoryTracker);
            countsStore.checkpoint(CursorContext.NULL);
        }
    }

    private void createEmptyTransactionLog() {
        TransactionLogInitializer.getLogFilesInitializer().initializeLogFiles(this.databaseLayout, (MetadataProvider)this.neoStores.getMetaDataStore(), this.fileSystem, CHECKPOINT_REASON);
    }

    private IndexDescriptor[] getIndexesNeedingPopulation(CursorContext cursorContext) {
        ArrayList<IndexDescriptor> indexesNeedingPopulation = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor descriptor : this.schemaCache.indexes()) {
            IndexProvider provider = this.indexProviderMap.lookup(descriptor.getIndexProvider());
            if (provider.getInitialState(descriptor, cursorContext) == InternalIndexState.FAILED) continue;
            indexesNeedingPopulation.add(descriptor);
        }
        return indexesNeedingPopulation.toArray(new IndexDescriptor[0]);
    }

    @Override
    public ConstraintCreator createDeferredConstraint(Label label) {
        return new BaseNodeConstraintCreator((InternalSchemaActions)new BatchSchemaActions(), null, label, null, null);
    }

    private IndexBackedConstraintDescriptor createUniqueIndexAndOwningConstraint(LabelSchemaDescriptor schema, IndexBackedConstraintDescriptor constraint, CursorContext cursorContext) {
        long indexId = this.schemaStore.nextId(cursorContext);
        long constraintRuleId = this.schemaStore.nextId(cursorContext);
        constraint = this.ensureSchemaHasName(constraint);
        IndexProvider provider = this.indexProviderMap.getDefaultProvider();
        IndexProviderDescriptor providerDescriptor = provider.getProviderDescriptor();
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor);
        IndexDescriptor index = prototype.withName(constraint.getName()).materialise(indexId);
        index = provider.completeConfiguration(index).withOwningConstraintId(constraintRuleId);
        constraint = constraint.withId(constraintRuleId).withOwnedIndexId(indexId);
        try {
            this.schemaRuleAccess.writeSchemaRule((SchemaRule)constraint, cursorContext, this.memoryTracker);
            this.schemaCache.addSchemaRule((SchemaRule)constraint);
            this.schemaRuleAccess.writeSchemaRule((SchemaRule)index, cursorContext, this.memoryTracker);
            this.schemaCache.addSchemaRule((SchemaRule)index);
            this.flushStrategy.forceFlush();
            return constraint;
        }
        catch (KernelException e) {
            throw BatchInserterImpl.kernelExceptionToUserException(e);
        }
    }

    private <T extends SchemaDescriptorSupplier> T ensureSchemaHasName(T schemaish) {
        String name;
        if (schemaish instanceof IndexPrototype) {
            name = ((IndexPrototype)schemaish).getName().orElse(null);
        } else if (schemaish instanceof SchemaRule) {
            name = ((SchemaRule)schemaish).getName();
        } else {
            throw new IllegalArgumentException("Don't know how to check the name of " + schemaish + ".");
        }
        if (name == null || (name = name.trim()).isEmpty() || name.isBlank()) {
            try {
                int i;
                SchemaDescriptor schema = schemaish.schema();
                TokenHolder entityTokenHolder = schema.entityType() == EntityType.NODE ? this.tokenHolders.labelTokens() : this.tokenHolders.relationshipTypeTokens();
                TokenHolder propertyKeyTokenHolder = this.tokenHolders.propertyKeyTokens();
                int[] entityTokenIds = schema.getEntityTokenIds();
                int[] propertyIds = schema.getPropertyIds();
                String[] entityTokenNames = new String[entityTokenIds.length];
                String[] propertyNames = new String[propertyIds.length];
                for (i = 0; i < entityTokenIds.length; ++i) {
                    entityTokenNames[i] = entityTokenHolder.getTokenById(entityTokenIds[i]).name();
                }
                for (i = 0; i < propertyIds.length; ++i) {
                    propertyNames[i] = propertyKeyTokenHolder.getTokenById(propertyIds[i]).name();
                }
                name = SchemaRule.generateName(schemaish, (String[])entityTokenNames, (String[])propertyNames);
                schemaish = schemaish instanceof IndexPrototype ? ((IndexPrototype)schemaish).withName(name) : ((SchemaRule)schemaish).withName(name);
            }
            catch (TokenNotFoundException e) {
                throw new TransactionFailureException("Failed to generate name for constraint: " + schemaish, (Throwable)e);
            }
        }
        return schemaish;
    }

    private static TransactionFailureException kernelExceptionToUserException(KernelException e) {
        throw new TransactionFailureException("Unexpected kernel exception writing schema rules", (Throwable)e);
    }

    private IndexBackedConstraintDescriptor createUniquenessConstraintRule(LabelSchemaDescriptor descriptor, String name) {
        return this.createUniqueIndexAndOwningConstraint(descriptor, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor).withName(name), this.cursorContext);
    }

    private IndexBackedConstraintDescriptor createNodeKeyConstraintRule(LabelSchemaDescriptor descriptor, String name) {
        return this.createUniqueIndexAndOwningConstraint(descriptor, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)descriptor).withName(name), this.cursorContext);
    }

    private ConstraintDescriptor createNodePropertyExistenceConstraintRule(String name, int labelId, int ... propertyKeyIds) {
        NodeExistenceConstraintDescriptor rule = ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])propertyKeyIds).withId(this.schemaStore.nextId(this.cursorContext)).withName(name);
        rule = (ConstraintDescriptor)this.ensureSchemaHasName(rule);
        try {
            this.schemaRuleAccess.writeSchemaRule((SchemaRule)rule, this.cursorContext, this.memoryTracker);
            this.schemaCache.addSchemaRule((SchemaRule)rule);
            this.flushStrategy.forceFlush();
            return rule;
        }
        catch (KernelException e) {
            throw BatchInserterImpl.kernelExceptionToUserException(e);
        }
    }

    private ConstraintDescriptor createRelTypePropertyExistenceConstraintRule(String name, int relTypeId, int ... propertyKeyIds) {
        RelExistenceConstraintDescriptor rule = ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])propertyKeyIds).withId(this.schemaStore.nextId(this.cursorContext)).withName(name);
        rule = (ConstraintDescriptor)this.ensureSchemaHasName(rule);
        try {
            this.schemaRuleAccess.writeSchemaRule((SchemaRule)rule, this.cursorContext, this.memoryTracker);
            this.schemaCache.addSchemaRule((SchemaRule)rule);
            this.flushStrategy.forceFlush();
            return rule;
        }
        catch (KernelException e) {
            throw BatchInserterImpl.kernelExceptionToUserException(e);
        }
    }

    private static int silentGetOrCreateTokenId(TokenHolder tokens, String name) {
        try {
            return tokens.getOrCreateId(name);
        }
        catch (KernelException e) {
            throw BatchInserterImpl.kernelExceptionToUserException(e);
        }
    }

    private int getOrCreatePropertyKeyId(String name) {
        return BatchInserterImpl.silentGetOrCreateTokenId(this.tokenHolders.propertyKeyTokens(), name);
    }

    private int getOrCreateRelationshipTypeId(String name) {
        return BatchInserterImpl.silentGetOrCreateTokenId(this.tokenHolders.relationshipTypeTokens(), name);
    }

    private int getOrCreateLabelId(String name) {
        return BatchInserterImpl.silentGetOrCreateTokenId(this.tokenHolders.labelTokens(), name);
    }

    private boolean primitiveHasProperty(PrimitiveRecord record, String propertyName) {
        int propertyKeyId = this.tokenHolders.propertyKeyTokens().getIdByName(propertyName);
        return propertyKeyId != -1 && this.propertyTraverser.findPropertyRecordContaining(record, propertyKeyId, this.recordAccess.getPropertyRecords(), false) != (long)Record.NO_NEXT_PROPERTY.intValue();
    }

    private static void rejectAutoUpgrade(Config config) {
        if (((Boolean)config.get(GraphDatabaseSettings.allow_upgrade)).booleanValue()) {
            throw new IllegalArgumentException("Batch inserter is not allowed to do upgrade of a store.");
        }
    }

    @Override
    public long createNode(Map<String, Object> properties, Label ... labels) {
        return this.internalCreateNode(this.nodeStore.nextId(this.cursorContext), properties, labels);
    }

    private long internalCreateNode(long nodeId, Map<String, Object> properties, Label ... labels) {
        NodeRecord nodeRecord = (NodeRecord)this.recordAccess.getNodeRecords().create(nodeId, null, this.cursorContext).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)nodeRecord, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        if (labels.length > 0) {
            this.setNodeLabels(nodeRecord, labels);
        }
        this.flushStrategy.flush();
        return nodeId;
    }

    private Iterator<PropertyBlock> propertiesIterator(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new IteratorWrapper<PropertyBlock, Map.Entry<String, Object>>(properties.entrySet().iterator()){

            protected PropertyBlock underlyingObjectToObject(Map.Entry<String, Object> property) {
                return BatchInserterImpl.this.propertyCreator.encodePropertyValue(BatchInserterImpl.this.getOrCreatePropertyKeyId(property.getKey()), ValueUtils.asValue((Object)property.getValue()));
            }
        };
    }

    private void setNodeLabels(NodeRecord nodeRecord, Label ... labels) {
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
        nodeLabels.put(this.getOrCreateLabelIds(labels), this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore(), this.cursorContext, this.memoryTracker);
    }

    private long[] getOrCreateLabelIds(Label[] labels) {
        long[] ids = new long[labels.length];
        int cursor = 0;
        for (int i = 0; i < ids.length; ++i) {
            int labelId = this.getOrCreateLabelId(labels[i].name());
            if (BatchInserterImpl.arrayContains(ids, cursor, labelId)) continue;
            ids[cursor++] = labelId;
        }
        if (cursor < ids.length) {
            ids = Arrays.copyOf(ids, cursor);
        }
        return ids;
    }

    private static boolean arrayContains(long[] ids, int cursor, int labelId) {
        for (int i = 0; i < cursor; ++i) {
            if (ids[i] != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createNode(long id, Map<String, Object> properties, Label ... labels) {
        IdValidator.assertValidId((IdType)IdType.NODE, (long)id, (long)this.maxNodeId);
        if (this.nodeStore.isInUse(id, this.cursorContext)) {
            throw new IllegalArgumentException("id=" + id + " already in use");
        }
        long highId = this.nodeStore.getHighId();
        if (highId <= id) {
            this.nodeStore.setHighestPossibleIdInUse(id);
        }
        this.internalCreateNode(id, properties, labels);
    }

    @Override
    public void setNodeLabels(long node, Label ... labels) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(node).forChangingData();
        this.setNodeLabels(record, labels);
        this.flushStrategy.flush();
    }

    @Override
    public Iterable<Label> getNodeLabels(long node) {
        return () -> {
            NodeRecord record = (NodeRecord)this.getNodeRecord(node).forReadingData();
            long[] labels = NodeLabelsField.parseLabelsField((NodeRecord)record).get(this.nodeStore, this.cursorContext);
            return LongStream.of(labels).mapToObj(this.labelIdToLabelFunction).iterator();
        };
    }

    @Override
    public boolean nodeHasLabel(long node, Label label) {
        int labelId = this.tokenHolders.labelTokens().getIdByName(label.name());
        return labelId != -1 && this.nodeHasLabel(node, labelId);
    }

    private boolean nodeHasLabel(long node, int labelId) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(node).forReadingData();
        for (long label : NodeLabelsField.parseLabelsField((NodeRecord)record).get(this.nodeStore, this.cursorContext)) {
            if (label != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        long id = this.relationshipStore.nextId(this.cursorContext);
        int typeId = this.getOrCreateRelationshipTypeId(type.name());
        this.relationshipCreator.relationshipCreate(id, typeId, node1, node2, (RecordAccessSet)this.recordAccess, this.degreeUpdater, (RelationshipCreator.NodeDataLookup)new RelationshipCreator.InsertFirst(this.relationshipGroupGetter, (RecordAccessSet)this.recordAccess, this.cursorContext));
        if (properties != null && !properties.isEmpty()) {
            RelationshipRecord record = (RelationshipRecord)this.recordAccess.getRelRecords().getOrLoad(id, null, this.cursorContext).forChangingData();
            record.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        }
        this.flushStrategy.flush();
        return id;
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(node).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain((PrimitiveRecord)record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        RelationshipRecord record = (RelationshipRecord)this.recordAccess.getRelRecords().getOrLoad(rel, null, this.cursorContext).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain((PrimitiveRecord)record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.flushStrategy.forceFlush();
        return this.nodeStore.isInUse(nodeId, this.cursorContext);
    }

    @Override
    public Map<String, Object> getNodeProperties(long nodeId) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(nodeId).forReadingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<Long>(this.storageReader, nodeId, this.cursorContext){

            @Override
            protected Long nextFrom(long relId, int type, long startNode, long endNode) {
                return relId;
            }
        };
    }

    @Override
    public Iterable<BatchRelationship> getRelationships(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<BatchRelationship>(this.storageReader, nodeId, this.cursorContext){

            @Override
            protected BatchRelationship nextFrom(long relId, int type, long startNode, long endNode) {
                return BatchInserterImpl.this.batchRelationshipOf(relId, type, startNode, endNode);
            }
        };
    }

    private BatchRelationship batchRelationshipOf(long id, int type, long startNode, long endNode) {
        try {
            return new BatchRelationship(id, startNode, endNode, RelationshipType.withName((String)this.tokenHolders.relationshipTypeTokens().getTokenById(type).name()));
        }
        catch (TokenNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BatchRelationship getRelationshipById(long relId) {
        RelationshipRecord record = (RelationshipRecord)this.getRelationshipRecord(relId).forReadingData();
        return this.batchRelationshipOf(relId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public Map<String, Object> getRelationshipProperties(long relId) {
        RelationshipRecord record = (RelationshipRecord)this.recordAccess.getRelRecords().getOrLoad(relId, null, this.cursorContext).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("Batch inserter already has shutdown");
        }
        this.isShutdown = true;
        this.flushStrategy.forceFlush();
        this.degreeUpdater.close();
        try (CursorContext cursorContext = this.cursorContext;
             Lifespan ignore = new Lifespan(new Lifecycle[]{this.life});
             Locker locker = this.locker;
             NeoStores neoStores = this.neoStores;
             GBPTreeRelationshipGroupDegreesStore gBPTreeRelationshipGroupDegreesStore = this.groupDegreesStore;){
            this.rebuildCounts(this.pageCacheTracer, this.memoryTracker);
            this.repopulateAllIndexes();
            this.idGeneratorFactory.visit(IdGenerator::markHighestWrittenAtHighId);
            this.neoStores.flush(this.cursorContext);
            this.groupDegreesStore.checkpoint(this.cursorContext);
            this.recordAccess.close();
            this.createEmptyTransactionLog();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.msgLog.info(Thread.currentThread() + " Clean shutdown on BatchInserter(" + this + ")");
    }

    public String toString() {
        return "EmbeddedBatchInserter[" + this.databaseLayout + "]";
    }

    private Map<String, Object> getPropertyChain(long nextProp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.propertyTraverser.getPropertyChain(nextProp, this.recordAccess.getPropertyRecords(), propBlock -> {
            try {
                String key = this.tokenHolders.propertyKeyTokens().getTokenById(propBlock.getKeyIndexId()).name();
                Value propertyValue = propBlock.newPropertyValue(this.propertyStore, this.cursorContext);
                map.put(key, propertyValue.asObject());
            }
            catch (TokenNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return map;
    }

    private int createNewPropertyKeyId(String stringKey, boolean internal) {
        return this.createNewToken((TokenStore)this.propertyKeyTokenStore, stringKey, internal);
    }

    private int createNewLabelId(String stringKey, boolean internal) {
        return this.createNewToken((TokenStore)this.labelTokenStore, stringKey, internal);
    }

    private int createNewRelationshipType(String name, boolean internal) {
        return this.createNewToken((TokenStore)this.relationshipTypeTokenStore, name, internal);
    }

    private <R extends TokenRecord> int createNewToken(TokenStore<R> store, String name, boolean internal) {
        int keyId = (int)store.nextId(this.cursorContext);
        TokenRecord record = (TokenRecord)store.newRecord();
        record.setId((long)keyId);
        record.setInUse(true);
        record.setInternal(internal);
        record.setCreated();
        Collection keyRecords = store.allocateNameRecords(PropertyStore.encodeString((String)name), this.cursorContext, this.memoryTracker);
        record.setNameId((int)((DynamicRecord)Iterables.first((Iterable)keyRecords)).getId());
        record.addNameRecords((Iterable)keyRecords);
        store.updateRecord((AbstractBaseRecord)record, this.cursorContext);
        return keyId;
    }

    private RecordAccess.RecordProxy<NodeRecord, Void> getNodeRecord(long id) {
        if (id < 0L || id >= this.nodeStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getNodeRecords().getOrLoad(id, null, this.cursorContext);
    }

    private RecordAccess.RecordProxy<RelationshipRecord, Void> getRelationshipRecord(long id) {
        if (id < 0L || id >= this.relationshipStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getRelRecords().getOrLoad(id, null, this.cursorContext);
    }

    @Override
    public String getStoreDir() {
        return this.databaseLayout.databaseDirectory().toString();
    }

    private static void dumpConfiguration(Config config) {
        System.out.print(config.toString());
    }

    @VisibleForTesting
    NeoStores getNeoStores() {
        return this.neoStores;
    }

    void forceFlushChanges() {
        this.flushStrategy.forceFlush();
    }

    static final class BatchedFlushStrategy
    implements FlushStrategy {
        private final DirectRecordAccessSet directRecordAccess;
        private final int batchSize;
        private int attempts;

        BatchedFlushStrategy(DirectRecordAccessSet directRecordAccess, int batchSize) {
            this.directRecordAccess = directRecordAccess;
            this.batchSize = batchSize;
        }

        @Override
        public void flush() {
            ++this.attempts;
            if (this.attempts >= this.batchSize) {
                this.forceFlush();
            }
        }

        @Override
        public void forceFlush() {
            this.directRecordAccess.commit();
            this.attempts = 0;
        }
    }

    static interface FlushStrategy {
        public void flush();

        public void forceFlush();
    }

    private class BatchSchemaActions
    implements InternalSchemaActions {
        private BatchSchemaActions() {
        }

        private int[] getOrCreatePropertyKeyIds(Iterable<String> properties) {
            return Iterables.stream(properties).mapToInt(x$0 -> BatchInserterImpl.this.getOrCreatePropertyKeyId((String)x$0)).toArray();
        }

        private int[] getOrCreatePropertyKeyIds(String[] properties) {
            return Arrays.stream(properties).mapToInt(x$0 -> BatchInserterImpl.this.getOrCreatePropertyKeyId((String)x$0)).toArray();
        }

        public IndexDefinition createIndexDefinition(Label[] labels, String indexName, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig, String ... propertyKeys) {
            if (indexConfig.entries().notEmpty()) {
                throw this.unsupportedException();
            }
            int[] labelIds = Arrays.stream(labels).mapToInt(label -> BatchInserterImpl.this.getOrCreateLabelId(label.name())).toArray();
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(propertyKeys);
            if (indexType == org.neo4j.graphdb.schema.IndexType.FULLTEXT) {
                throw this.unsupportedException();
            }
            if (labelIds.length != 1) {
                throw new IllegalArgumentException(indexType + " indexes can only be created with exactly one label.");
            }
            LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelIds[0], (int[])propertyKeyIds);
            BatchInserterImpl.this.validateIndexCanBeCreated((SchemaDescriptor)schema);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withName(indexName).withIndexType(IndexType.fromPublicApi((org.neo4j.graphdb.schema.IndexType)indexType));
            IndexDescriptor index = BatchInserterImpl.this.createIndex(prototype);
            return new IndexDefinitionImpl((InternalSchemaActions)this, index, labels, propertyKeys, false);
        }

        public IndexDefinition createIndexDefinition(RelationshipType[] types, String indexName, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig, String ... propertyKeys) {
            throw this.unsupportedException();
        }

        public IndexDefinition createIndexDefinition(AnyTokens tokens, String indexName, IndexConfig indexConfig) {
            throw this.unsupportedException();
        }

        public void dropIndexDefinitions(IndexDefinition indexDefinition) {
            throw this.unsupportedException();
        }

        public ConstraintDefinition createPropertyUniquenessConstraint(IndexDefinition indexDefinition, String name, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig) {
            LabelSchemaDescriptor descriptor = this.indexDefinitionToLabelSchemaDescriptor(indexDefinition, indexType, indexConfig);
            BatchInserterImpl.this.validateUniquenessConstraintCanBeCreated(descriptor);
            IndexBackedConstraintDescriptor constraint = BatchInserterImpl.this.createUniquenessConstraintRule(descriptor, name);
            return new UniquenessConstraintDefinition((InternalSchemaActions)this, (ConstraintDescriptor)constraint, indexDefinition);
        }

        public ConstraintDefinition createNodeKeyConstraint(IndexDefinition indexDefinition, String name, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig) {
            LabelSchemaDescriptor descriptor = this.indexDefinitionToLabelSchemaDescriptor(indexDefinition, indexType, indexConfig);
            BatchInserterImpl.this.validateNodeKeyConstraintCanBeCreated(descriptor);
            IndexBackedConstraintDescriptor constraint = BatchInserterImpl.this.createNodeKeyConstraintRule(descriptor, name);
            return new NodeKeyConstraintDefinition((InternalSchemaActions)this, (ConstraintDescriptor)constraint, indexDefinition);
        }

        private LabelSchemaDescriptor indexDefinitionToLabelSchemaDescriptor(IndexDefinition indexDefinition, org.neo4j.graphdb.schema.IndexType indexType, IndexConfig indexConfig) {
            if (indexType != null) {
                throw this.unsupportedException();
            }
            if (indexConfig != null) {
                throw this.unsupportedException();
            }
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(((Label)Iterables.single((Iterable)indexDefinition.getLabels())).name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(indexDefinition.getPropertyKeys());
            return SchemaDescriptor.forLabel((int)labelId, (int[])propertyKeyIds);
        }

        public ConstraintDefinition createPropertyExistenceConstraint(String name, Label label, String ... propertyKeys) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(propertyKeys);
            BatchInserterImpl.this.validateNodePropertyExistenceConstraintCanBeCreated(labelId, propertyKeyIds);
            ConstraintDescriptor constraint = BatchInserterImpl.this.createNodePropertyExistenceConstraintRule(name, labelId, propertyKeyIds);
            return new NodePropertyExistenceConstraintDefinition((InternalSchemaActions)this, constraint, label, propertyKeys);
        }

        public ConstraintDefinition createPropertyExistenceConstraint(String name, RelationshipType type, String propertyKey) {
            int relationshipTypeId = BatchInserterImpl.this.getOrCreateRelationshipTypeId(type.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.validateRelationshipConstraintCanBeCreated(relationshipTypeId, propertyKeyId);
            ConstraintDescriptor constraint = BatchInserterImpl.this.createRelTypePropertyExistenceConstraintRule(name, relationshipTypeId, propertyKeyId);
            return new RelationshipPropertyExistenceConstraintDefinition((InternalSchemaActions)this, constraint, type, propertyKey);
        }

        public void dropConstraint(ConstraintDescriptor constraint) {
            throw this.unsupportedException();
        }

        public String getUserMessage(KernelException e) {
            throw this.unsupportedException();
        }

        public String getUserDescription(IndexDescriptor index) {
            return index == null ? null : index.userDescription((TokenNameLookup)BatchInserterImpl.this.tokenHolders);
        }

        public void assertInOpenTransaction() {
        }

        private UnsupportedOperationException unsupportedException() {
            return new UnsupportedOperationException("Batch inserter doesn't support this");
        }
    }
}

