/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.batchinsert.internal.BatchInserterImpl;
import org.neo4j.internal.recordstorage.DirectRecordAccessSet;

class BatchedFlushStrategyTest {
    BatchedFlushStrategyTest() {
    }

    @Test
    void testFlush() {
        DirectRecordAccessSet recordAccessSet = (DirectRecordAccessSet)Mockito.mock(DirectRecordAccessSet.class);
        BatchInserterImpl.BatchedFlushStrategy flushStrategy = BatchedFlushStrategyTest.createFlushStrategy(recordAccessSet, 2);
        flushStrategy.flush();
        Mockito.verifyNoInteractions((Object[])new Object[]{recordAccessSet});
        flushStrategy.flush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet)).commit();
        Mockito.reset((Object[])new DirectRecordAccessSet[]{recordAccessSet});
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        flushStrategy.flush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet, (VerificationMode)Mockito.times((int)3))).commit();
    }

    @Test
    void testForceFlush() {
        DirectRecordAccessSet recordAccessSet = (DirectRecordAccessSet)Mockito.mock(DirectRecordAccessSet.class);
        BatchInserterImpl.BatchedFlushStrategy flushStrategy = BatchedFlushStrategyTest.createFlushStrategy(recordAccessSet, 2);
        flushStrategy.forceFlush();
        flushStrategy.forceFlush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet, (VerificationMode)Mockito.times((int)2))).commit();
        flushStrategy.flush();
        flushStrategy.forceFlush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet, (VerificationMode)Mockito.times((int)3))).commit();
    }

    @Test
    void testResetBatchCounterOnForce() {
        DirectRecordAccessSet recordAccessSet = (DirectRecordAccessSet)Mockito.mock(DirectRecordAccessSet.class);
        BatchInserterImpl.BatchedFlushStrategy flushStrategy = BatchedFlushStrategyTest.createFlushStrategy(recordAccessSet, 3);
        flushStrategy.flush();
        flushStrategy.flush();
        Mockito.verifyNoInteractions((Object[])new Object[]{recordAccessSet});
        flushStrategy.forceFlush();
        ((DirectRecordAccessSet)Mockito.verify((Object)recordAccessSet)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{recordAccessSet});
        flushStrategy.flush();
        flushStrategy.flush();
    }

    private static BatchInserterImpl.BatchedFlushStrategy createFlushStrategy(DirectRecordAccessSet recordAccessSet, int batchSize) {
        return new BatchInserterImpl.BatchedFlushStrategy(recordAccessSet, batchSize);
    }
}

