/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.annotations.Description;
import org.neo4j.annotations.Public;
import org.neo4j.capabilities.Capabilities;
import org.neo4j.capabilities.CapabilitiesRegistry;
import org.neo4j.capabilities.CapabilitiesService;
import org.neo4j.capabilities.CapabilitiesSettings;
import org.neo4j.capabilities.Capability;
import org.neo4j.capabilities.CapabilityDeclaration;
import org.neo4j.capabilities.CapabilityProvider;
import org.neo4j.capabilities.CapabilityProviderContext;
import org.neo4j.capabilities.Name;
import org.neo4j.capabilities.Type;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;

class CapabilitiesServiceTest {
    CapabilitiesServiceTest() {
    }

    @Test
    void shouldAllowEmptyDeclarations() {
        CapabilitiesService capabilities = new CapabilitiesService(Collections.emptyList(), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        Assertions.assertThat((Collection)capabilities.declaredCapabilities()).isEmpty();
    }

    @Test
    void shouldDiscoverGivenDeclarations() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class, TestCypherCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        Collection declared = capabilities.declaredCapabilities();
        Assertions.assertThat((Collection)declared).containsExactlyInAnyOrder((Object[])new Capability[]{TestCoreCapabilities.dbms_instance_version, TestCoreCapabilities.dbms_instance_internal_version, TestCypherCapabilities.dbms_cypher_version, TestCypherCapabilities.dbms_cypher_runtimes});
        Assertions.assertThat((String)TestCoreCapabilities.dbms_instance_version.description()).isEqualTo("version of the instance");
        Assertions.assertThat((boolean)TestCoreCapabilities.dbms_instance_version.internal()).isFalse();
        Assertions.assertThat((String)TestCoreCapabilities.dbms_instance_internal_version.description()).isEqualTo("internal version of the instance");
        Assertions.assertThat((boolean)TestCoreCapabilities.dbms_instance_internal_version.internal()).isTrue();
        Assertions.assertThat((String)TestCypherCapabilities.dbms_cypher_version.description()).isEqualTo("cypher version");
        Assertions.assertThat((boolean)TestCypherCapabilities.dbms_cypher_version.internal()).isFalse();
        Assertions.assertThat((String)TestCypherCapabilities.dbms_cypher_runtimes.description()).isEqualTo("available cypher runtimes");
        Assertions.assertThat((boolean)TestCypherCapabilities.dbms_cypher_runtimes.internal()).isFalse();
    }

    @Test
    void shouldThrowWhenDuplicateDeclarationsFound() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new CapabilitiesService(List.of(TestCoreCapabilities.class, TestCypherCapabilities.class, TestDuplicateCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]))).isInstanceOf(UnsupportedOperationException.class)).hasMessage("duplicate capability dbms.cypher.version");
    }

    @Test
    void shouldReturnAnUnmodifiableInstance() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        Capabilities unmodifiable = capabilities.unmodifiable();
        Assertions.assertThat((Object)unmodifiable).isInstanceOf(Capabilities.class);
        Assertions.assertThat((Object)unmodifiable).isNotInstanceOf(CapabilitiesRegistry.class);
    }

    @Test
    void shouldSetAndGetStaticValues() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        capabilities.set(TestCoreCapabilities.dbms_instance_version, (Object)"4.3.0");
        capabilities.set(TestCoreCapabilities.dbms_instance_internal_version, (Object)"4.3.0-drop03");
        Assertions.assertThat((String)((String)capabilities.get(TestCoreCapabilities.dbms_instance_version))).isEqualTo("4.3.0");
        Assertions.assertThat((String)((String)capabilities.get(TestCoreCapabilities.dbms_instance_internal_version))).isEqualTo("4.3.0-drop03");
        Assertions.assertThat((String)((String)capabilities.unmodifiable().get(TestCoreCapabilities.dbms_instance_version))).isEqualTo("4.3.0");
        Assertions.assertThat((String)((String)capabilities.unmodifiable().get(TestCoreCapabilities.dbms_instance_internal_version))).isEqualTo("4.3.0-drop03");
    }

    @Test
    void shouldSetAndGetDynamicValues() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        capabilities.supply(TestCoreCapabilities.dbms_instance_version, () -> "4.3.0");
        capabilities.supply(TestCoreCapabilities.dbms_instance_internal_version, () -> "4.3.0-drop03");
        Assertions.assertThat((String)((String)capabilities.get(TestCoreCapabilities.dbms_instance_version))).isEqualTo("4.3.0");
        Assertions.assertThat((String)((String)capabilities.get(TestCoreCapabilities.dbms_instance_internal_version))).isEqualTo("4.3.0-drop03");
        Assertions.assertThat((String)((String)capabilities.unmodifiable().get(TestCoreCapabilities.dbms_instance_version))).isEqualTo("4.3.0");
        Assertions.assertThat((String)((String)capabilities.unmodifiable().get(TestCoreCapabilities.dbms_instance_internal_version))).isEqualTo("4.3.0-drop03");
    }

    @Test
    void shouldReturnNullForUnsetCapabilities() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        Assertions.assertThat((String)((String)capabilities.get(TestCoreCapabilities.dbms_instance_version))).isNull();
    }

    @Test
    void shouldReturnNullForUnregisteredCapabilities() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        Assertions.assertThat((Object)capabilities.get(Name.of((String)"dbms.instance.unregistered"))).isNull();
    }

    @Test
    void shouldThrowWhileSettingUnknownCapabilities() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class), Collections.emptyList(), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        Assertions.assertThatThrownBy(() -> capabilities.set(TestCypherCapabilities.dbms_cypher_version, (Object)"4.3.0")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> capabilities.supply(TestCypherCapabilities.dbms_cypher_version, () -> "4.3.0")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldProcessProviders() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestProviderCapabilities.class), List.of(new TestProviderA(), new TestProviderB()), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        capabilities.processProviders();
        Assertions.assertThat((String)((String)capabilities.get(TestProviderCapabilities.component_a_version))).isEqualTo("5.2");
        Assertions.assertThat((Boolean)((Boolean)capabilities.get(TestProviderCapabilities.component_a_authentication_supported))).isTrue();
        Assertions.assertThat((String)((String)capabilities.get(TestProviderCapabilities.component_b_version))).isEqualTo("2.3");
        Assertions.assertThat((Collection)((Collection)capabilities.get(TestProviderCapabilities.component_b_supported_versions))).containsExactly((Object[])new String[]{"2.0", "2.1", "2.2"});
    }

    @Test
    void shouldProcessProvidersWithContext() {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.initial_default_database, (Object)"my-db");
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestProviderCapabilities.class), List.of(new TestProviderBFromConfig()), (Configuration)config, (DependencyResolver)CapabilitiesServiceTest.newDependencies(config));
        capabilities.processProviders();
        Assertions.assertThat((String)((String)capabilities.get(TestProviderCapabilities.component_b_db_name))).isEqualTo("my-db");
    }

    @Test
    void shouldThrowWhenNamespaceOutOfRange() {
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestProviderCapabilities.class), List.of(new TestProviderA(), new TestProviderNamespaceError()), (Configuration)Config.defaults(), (DependencyResolver)CapabilitiesServiceTest.newDependencies(new Object[0]));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CapabilitiesService)capabilities).processProviders()).isInstanceOf(IllegalArgumentException.class)).hasMessage("provided capability org.example.componentB.version is not in declared namespace org.example.component");
    }

    @Test
    void shouldRemoveBlockedFromDeclaredCapabilities() {
        Config config = Config.newBuilder().set(CapabilitiesSettings.dbms_capabilities_blocked, List.of("org.example.**", "**.version")).build();
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class, TestCypherCapabilities.class, TestProviderCapabilities.class), Collections.emptyList(), (Configuration)config, (DependencyResolver)CapabilitiesServiceTest.newDependencies(config));
        Assertions.assertThat((Collection)capabilities.declaredCapabilities()).doesNotContain((Object[])new Capability[]{TestProviderCapabilities.component_a_version, TestProviderCapabilities.component_a_authentication_supported, TestProviderCapabilities.component_b_version, TestProviderCapabilities.component_b_supported_versions, TestCoreCapabilities.dbms_instance_version, TestCypherCapabilities.dbms_cypher_version});
    }

    @Test
    void shouldNotReturnBlockedCapabilities() {
        Config config = Config.newBuilder().set(CapabilitiesSettings.dbms_capabilities_blocked, List.of("org.example.componentA.**", "dbms.**.version")).build();
        CapabilitiesService capabilities = new CapabilitiesService(List.of(TestCoreCapabilities.class, TestCypherCapabilities.class, TestProviderCapabilities.class), List.of(new TestProviderA(), new TestProviderB()), (Configuration)config, (DependencyResolver)CapabilitiesServiceTest.newDependencies(config));
        capabilities.processProviders();
        Assertions.assertThatCode(() -> capabilities.set(TestCoreCapabilities.dbms_instance_version, (Object)"4.3.0")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> capabilities.set(TestCoreCapabilities.dbms_instance_internal_version, (Object)"4.3.0-internal")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> capabilities.set(TestCypherCapabilities.dbms_cypher_version, (Object)"4.3.0")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> capabilities.set(TestCypherCapabilities.dbms_cypher_runtimes, List.of("a", "b"))).doesNotThrowAnyException();
        Assertions.assertThat((String)((String)capabilities.get(TestCoreCapabilities.dbms_instance_version))).isNull();
        Assertions.assertThat((String)((String)capabilities.get(TestCypherCapabilities.dbms_cypher_version))).isNull();
        Assertions.assertThat((String)((String)capabilities.get(TestProviderCapabilities.component_a_version))).isNull();
        Assertions.assertThat((Boolean)((Boolean)capabilities.get(TestProviderCapabilities.component_a_authentication_supported))).isNull();
        Assertions.assertThat((String)((String)capabilities.get(TestCoreCapabilities.dbms_instance_internal_version))).isEqualTo("4.3.0-internal");
        Assertions.assertThat((Collection)((Collection)capabilities.get(TestCypherCapabilities.dbms_cypher_runtimes))).containsExactly((Object[])new String[]{"a", "b"});
        Assertions.assertThat((String)((String)capabilities.get(TestProviderCapabilities.component_b_version))).isEqualTo("2.3");
        Assertions.assertThat((Collection)((Collection)capabilities.get(TestProviderCapabilities.component_b_supported_versions))).containsExactly((Object[])new String[]{"2.0", "2.1", "2.2"});
    }

    private static Dependencies newDependencies(Object ... dependencies) {
        Dependencies deps = Dependencies.dependenciesOf((Object[])dependencies);
        if (!deps.containsDependency(Configuration.class)) {
            deps.satisfyDependency((Object)Config.defaults());
        }
        return deps;
    }

    private static class TestCoreCapabilities
    implements CapabilityDeclaration {
        @Public
        @Description(value="version of the instance")
        public static final Capability<String> dbms_instance_version = new Capability(Name.of((String)"dbms.instance.version"), Type.STRING);
        @Description(value="internal version of the instance")
        public static final Capability<String> dbms_instance_internal_version = new Capability(Name.of((String)"dbms.instance.internal_version"), Type.STRING);

        private TestCoreCapabilities() {
        }
    }

    private static class TestCypherCapabilities
    implements CapabilityDeclaration {
        @Public
        @Description(value="available cypher runtimes")
        public static final Capability<Collection<String>> dbms_cypher_runtimes = new Capability(Name.of((String)"dbms.cypher.runtimes"), Type.listOf((Type)Type.STRING));
        @Public
        @Description(value="cypher version")
        public static final Capability<String> dbms_cypher_version = new Capability(Name.of((String)"dbms.cypher.version"), Type.STRING);

        private TestCypherCapabilities() {
        }
    }

    private static class TestProviderCapabilities
    implements CapabilityDeclaration {
        @Public
        @Description(value="component a version")
        public static final Capability<String> component_a_version = new Capability(Name.of((String)"org.example.componentA.version"), Type.STRING);
        @Public
        @Description(value="component a supports authentication")
        public static final Capability<Boolean> component_a_authentication_supported = new Capability(Name.of((String)"org.example.componentA.supports_authentication"), Type.BOOLEAN);
        @Public
        @Description(value="component b version")
        public static final Capability<String> component_b_version = new Capability(Name.of((String)"org.example.componentB.version"), Type.STRING);
        @Public
        @Description(value="component b supported list of versions")
        public static final Capability<Collection<String>> component_b_supported_versions = new Capability(Name.of((String)"org.example.componentB.supported_versions"), Type.listOf((Type)Type.STRING));
        @Public
        @Description(value="component b database name")
        public static final Capability<String> component_b_db_name = new Capability(Name.of((String)"org.example.componentB.db_name"), Type.STRING);

        private TestProviderCapabilities() {
        }
    }

    private static class TestProviderA
    implements CapabilityProvider {
        private TestProviderA() {
        }

        public String namespace() {
            return "org.example.componentA";
        }

        public void register(CapabilityProviderContext ctx, CapabilitiesRegistry registry) {
            registry.set(TestProviderCapabilities.component_a_version, (Object)"5.2");
            registry.supply(TestProviderCapabilities.component_a_authentication_supported, () -> true);
        }
    }

    private static class TestProviderB
    implements CapabilityProvider {
        private TestProviderB() {
        }

        public String namespace() {
            return "org.example.componentB";
        }

        public void register(CapabilityProviderContext ctx, CapabilitiesRegistry registry) {
            registry.set(TestProviderCapabilities.component_b_version, (Object)"2.3");
            registry.supply(TestProviderCapabilities.component_b_supported_versions, () -> List.of("2.0", "2.1", "2.2"));
        }
    }

    private static class TestProviderBFromConfig
    implements CapabilityProvider {
        private TestProviderBFromConfig() {
        }

        public String namespace() {
            return "org.example.componentB";
        }

        public void register(CapabilityProviderContext ctx, CapabilitiesRegistry registry) {
            registry.set(TestProviderCapabilities.component_b_db_name, (Object)((String)ctx.config().get(GraphDatabaseSettings.initial_default_database)));
        }
    }

    private static class TestProviderNamespaceError
    implements CapabilityProvider {
        private TestProviderNamespaceError() {
        }

        public String namespace() {
            return "org.example.component";
        }

        public void register(CapabilityProviderContext ctx, CapabilitiesRegistry registry) {
            registry.set(TestProviderCapabilities.component_b_version, (Object)"2.3");
            registry.supply(TestProviderCapabilities.component_b_supported_versions, () -> List.of("2.0", "2.1", "2.2"));
        }
    }

    private static class TestDuplicateCapabilities
    implements CapabilityDeclaration {
        @Public
        @Description(value="duplicate cypher version")
        public static final Capability<String> dbms_cypher_version = new Capability(Name.of((String)"dbms.cypher.version"), Type.STRING);

        private TestDuplicateCapabilities() {
        }
    }
}

