/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.capabilities.Capabilities;
import org.neo4j.capabilities.CapabilityProviderContext;
import org.neo4j.capabilities.CapabilityProviderDependencies;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.logging.InternalLog;

class CapabilityProviderContextTest {
    CapabilityProviderContextTest() {
    }

    @Test
    void shouldResolveComponents() {
        InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
        Configuration config = (Configuration)Mockito.mock(Configuration.class);
        DatabaseManagementService dbms = (DatabaseManagementService)Mockito.mock(DatabaseManagementService.class);
        Capabilities caps = (Capabilities)Mockito.mock(Capabilities.class);
        CapabilityProviderDependencies deps = new CapabilityProviderDependencies();
        deps.register(InternalLog.class, () -> log);
        deps.register(Configuration.class, () -> config);
        deps.register(DatabaseManagementService.class, () -> dbms);
        deps.register(Capabilities.class, () -> caps);
        CapabilityProviderContext ctx = new CapabilityProviderContext(deps);
        Assertions.assertThat((Object)ctx.log()).isSameAs((Object)log);
        Assertions.assertThat((Object)ctx.config()).isSameAs((Object)config);
        Assertions.assertThat((Object)ctx.dbms()).isSameAs((Object)dbms);
        Assertions.assertThat((Object)((Capabilities)ctx.get(Capabilities.class))).isSameAs((Object)caps);
    }
}

