/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.capabilities.CapabilityProviderDependencies;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.logging.InternalLog;

class CapabilityProviderDependenciesTest {
    CapabilityProviderDependenciesTest() {
    }

    @Test
    void shouldRegisterAndGet() {
        CapabilityProviderDependencies deps = new CapabilityProviderDependencies();
        InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
        deps.register(InternalLog.class, () -> log);
        Assertions.assertThat((Object)((InternalLog)deps.get(InternalLog.class))).isSameAs((Object)log);
    }

    @Test
    void shouldNotRegisterTwice() {
        CapabilityProviderDependencies deps = new CapabilityProviderDependencies();
        InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
        Assertions.assertThatCode(() -> deps.register(InternalLog.class, () -> log)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> deps.register(InternalLog.class, () -> log)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void shouldThrowIfNotRegistered() {
        CapabilityProviderDependencies deps = new CapabilityProviderDependencies();
        Assertions.assertThatCode(() -> deps.get(InternalLog.class)).isInstanceOf(UnsatisfiedDependencyException.class);
    }
}

