/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.capabilities.Name;

class NameTest {
    NameTest() {
    }

    @Test
    void testConstruction() {
        Name root = Name.of((String)"");
        Assertions.assertThat((String)root.fullName()).isEqualTo("");
        Assertions.assertThat((String)root.toString()).isEqualTo("");
        Name dbms = Name.of((String)"dbms");
        Assertions.assertThat((String)dbms.fullName()).isEqualTo("dbms");
        Assertions.assertThat((String)dbms.toString()).isEqualTo("dbms");
        Name dbmsInstance = Name.of((String)"dbms.instance");
        Assertions.assertThat((String)dbmsInstance.fullName()).isEqualTo("dbms.instance");
        Assertions.assertThat((String)dbmsInstance.toString()).isEqualTo("dbms.instance");
        dbmsInstance = dbms.child("instance");
        Assertions.assertThat((String)dbmsInstance.fullName()).isEqualTo("dbms.instance");
        Assertions.assertThat((String)dbmsInstance.toString()).isEqualTo("dbms.instance");
    }

    @Test
    void testIsIn() {
        Name root = Name.of((String)"");
        Name dbms = root.child("dbms");
        Name dbmsInstance = dbms.child("instance");
        Name dbmsInstanceKernel = dbmsInstance.child("kernel");
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn(dbmsInstanceKernel)).isTrue();
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn(dbmsInstance)).isTrue();
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn(dbms)).isTrue();
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn(root)).isTrue();
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn("dbms.instance.kernel")).isTrue();
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn("dbms.instance")).isTrue();
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn("dbms")).isTrue();
        Assertions.assertThat((boolean)dbmsInstanceKernel.isIn("")).isTrue();
        Assertions.assertThat((boolean)dbmsInstance.isIn("dbms.cluster")).isFalse();
        Assertions.assertThat((boolean)dbmsInstance.isIn("cluster")).isFalse();
        Assertions.assertThat((boolean)dbmsInstance.isIn(dbmsInstanceKernel)).isFalse();
        Assertions.assertThat((boolean)root.isIn(dbms)).isFalse();
    }

    @Test
    void testEquals() {
        Assertions.assertThat((boolean)Name.of((String)"").equals((Object)Name.of((String)""))).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").equals((Object)Name.of((String)"dbms.instance.kernel.version"))).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").equals((Object)Name.of((String)"dbms.instance.kernel").child("version"))).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").equals((Object)Name.of((String)"cluster.instance"))).isFalse();
        Assertions.assertThat((boolean)Name.of((String)"dbms").equals((Object)Name.of((String)""))).isFalse();
        Assertions.assertThat((boolean)Name.of((String)"dbms").equals((Object)"dbms")).isFalse();
        Assertions.assertThat((boolean)Name.of((String)"dbms").equals(null)).isFalse();
    }

    @Test
    void testChildThrowsWhenInvalid() {
        Name root = Name.of((String)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> root.child("")).isInstanceOf(IllegalArgumentException.class)).hasMessage("'' is not a valid name");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> root.child("dbms.instance")).isInstanceOf(IllegalArgumentException.class)).hasMessage("'dbms.instance' is not a valid name");
    }

    @Test
    void testThrowsOnInvalidName() {
        Assertions.assertThatCode(() -> Name.of((String)"")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> Name.of((String)"dbms")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> Name.of((String)"dbms.instance")).doesNotThrowAnyException();
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> Name.of((String)"my-dbms.instance")).isInstanceOf(IllegalArgumentException.class)).hasMessage("'my-dbms.instance' is not a valid name.");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> Name.of((String)"dbms.instance.")).isInstanceOf(IllegalArgumentException.class)).hasMessage("'dbms.instance.' is not a valid name.");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> Name.of((String)".dbms.instance")).isInstanceOf(IllegalArgumentException.class)).hasMessage("'.dbms.instance' is not a valid name.");
    }

    @Test
    void testMatches() {
        Assertions.assertThat((boolean)Name.of((String)"dbms").matches("dbms")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("dbms.instance")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("dbms.instance2")).isFalse();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("dbms.*")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("dbms.inst*")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("dbms.instance*")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("dbms.**")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("dbms.**.version")).isFalse();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance").matches("*.instance")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.version").matches("dbms.instance.*")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.version").matches("dbms.instance.**")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("dbms.instance.*.version")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.bolt.version").matches("dbms.instance.*.version")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("dbms.**")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("dbms.**.version")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("dbms.**.allowed")).isFalse();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("**.allowed")).isFalse();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("**.instance.**")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("**instance**")).isTrue();
        Assertions.assertThat((boolean)Name.of((String)"dbms.instance.kernel.version").matches("**instance.**")).isTrue();
    }
}

