/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import io.netty.channel.ChannelInboundHandler;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.causalclustering.catchup.CatchupProtocolServerInstaller;
import org.neo4j.causalclustering.catchup.CatchupServerHandler;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServerInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CatchupServerBuilder {
    private final CatchupServerHandler catchupServerHandler;
    private LogProvider debugLogProvider = NullLogProvider.getInstance();
    private LogProvider userLogProvider = NullLogProvider.getInstance();
    private NettyPipelineBuilderFactory pipelineBuilder = new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER);
    private ApplicationSupportedProtocols catchupProtocols = new ApplicationSupportedProtocols(Protocol.ApplicationProtocolCategory.CATCHUP, Collections.emptyList());
    private Collection<ModifierSupportedProtocols> modifierProtocols = Collections.emptyList();
    private ChannelInboundHandler parentHandler;
    private ListenSocketAddress listenAddress;
    private String serverName = "catchup-server";

    public CatchupServerBuilder(CatchupServerHandler catchupServerHandler) {
        this.catchupServerHandler = catchupServerHandler;
    }

    public CatchupServerBuilder catchupProtocols(ApplicationSupportedProtocols catchupProtocols) {
        this.catchupProtocols = catchupProtocols;
        return this;
    }

    public CatchupServerBuilder modifierProtocols(Collection<ModifierSupportedProtocols> modifierProtocols) {
        this.modifierProtocols = modifierProtocols;
        return this;
    }

    public CatchupServerBuilder pipelineBuilder(NettyPipelineBuilderFactory pipelineBuilder) {
        this.pipelineBuilder = pipelineBuilder;
        return this;
    }

    public CatchupServerBuilder serverHandler(ChannelInboundHandler parentHandler) {
        this.parentHandler = parentHandler;
        return this;
    }

    public CatchupServerBuilder listenAddress(ListenSocketAddress listenAddress) {
        this.listenAddress = listenAddress;
        return this;
    }

    public CatchupServerBuilder userLogProvider(LogProvider userLogProvider) {
        this.userLogProvider = userLogProvider;
        return this;
    }

    public CatchupServerBuilder debugLogProvider(LogProvider debugLogProvider) {
        this.debugLogProvider = debugLogProvider;
        return this;
    }

    public CatchupServerBuilder serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public Server build() {
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository(Protocol.ApplicationProtocols.values(), this.catchupProtocols);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository(Protocol.ModifierProtocols.values(), this.modifierProtocols);
        CatchupProtocolServerInstaller.Factory catchupProtocolServerInstaller = new CatchupProtocolServerInstaller.Factory(this.pipelineBuilder, this.debugLogProvider, this.catchupServerHandler);
        ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server> protocolInstallerRepository = new ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server>(Collections.singletonList(catchupProtocolServerInstaller), ModifierProtocolInstaller.allServerInstallers);
        HandshakeServerInitializer handshakeServerInitializer = new HandshakeServerInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, this.pipelineBuilder, this.debugLogProvider);
        return new Server(handshakeServerInitializer, this.parentHandler, this.debugLogProvider, this.userLogProvider, this.listenAddress, this.serverName);
    }
}

