/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.neo4j.causalclustering.catchup.storecopy.FileChunk;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;

class FileSender
implements ChunkedInput<FileChunk> {
    private final StoreResource resource;
    private final ByteBuffer byteBuffer;
    private ReadableByteChannel channel;
    private byte[] nextBytes;
    private State state = State.PRE_INIT;

    FileSender(StoreResource resource) {
        this.resource = resource;
        this.byteBuffer = ByteBuffer.allocateDirect(8192);
    }

    public boolean isEndOfInput() {
        return this.state == State.FINISHED;
    }

    public void close() throws Exception {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public FileChunk readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.state == State.FINISHED) {
            return null;
        }
        if (this.state == State.PRE_INIT) {
            this.channel = this.resource.open();
            this.nextBytes = this.prefetch();
            if (this.nextBytes == null) {
                this.state = State.FINISHED;
                return FileChunk.create(new byte[0], true);
            }
            State state = this.state = this.nextBytes.length < 8192 ? State.LAST_PENDING : State.FULL_PENDING;
        }
        if (this.state == State.FULL_PENDING) {
            byte[] toSend = this.nextBytes;
            this.nextBytes = this.prefetch();
            if (this.nextBytes == null) {
                this.state = State.FINISHED;
                return FileChunk.create(toSend, true);
            }
            if (this.nextBytes.length < 8192) {
                this.state = State.LAST_PENDING;
                return FileChunk.create(toSend, false);
            }
            return FileChunk.create(toSend, false);
        }
        if (this.state == State.LAST_PENDING) {
            this.state = State.FINISHED;
            return FileChunk.create(this.nextBytes, true);
        }
        throw new IllegalStateException();
    }

    public FileChunk readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSender that = (FileSender)o;
        return Objects.equals(this.resource, that.resource);
    }

    public int hashCode() {
        return Objects.hash(this.resource);
    }

    private byte[] prefetch() throws IOException {
        int bytesRead;
        while ((bytesRead = this.channel.read(this.byteBuffer)) != -1 && this.byteBuffer.hasRemaining()) {
        }
        if (this.byteBuffer.position() > 0) {
            return this.createByteArray(this.byteBuffer);
        }
        return null;
    }

    private byte[] createByteArray(ByteBuffer buffer) {
        buffer.flip();
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        buffer.clear();
        return bytes;
    }

    static enum State {
        PRE_INIT,
        FULL_PENDING,
        LAST_PENDING,
        FINISHED;

    }
}

