/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.neo4j.causalclustering.catchup.RequestMessageType;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkFlushableByteBuf;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.StoreCopyRequest;
import org.neo4j.causalclustering.messaging.marshalling.storeid.StoreIdMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.string.UTF8;

public class GetStoreFileRequest
implements StoreCopyRequest {
    private final StoreId expectedStoreId;
    private final File file;
    private final long requiredTransactionId;

    public GetStoreFileRequest(StoreId expectedStoreId, File file, long requiredTransactionId) {
        this.expectedStoreId = expectedStoreId;
        this.file = file;
        this.requiredTransactionId = requiredTransactionId;
    }

    @Override
    public long requiredTransactionId() {
        return this.requiredTransactionId;
    }

    @Override
    public StoreId expectedStoreId() {
        return this.expectedStoreId;
    }

    File file() {
        return this.file;
    }

    @Override
    public RequestMessageType messageType() {
        return RequestMessageType.STORE_FILE;
    }

    public String toString() {
        return "GetStoreFileRequest{expectedStoreId=" + this.expectedStoreId + ", file=" + this.file.getName() + ", requiredTransactionId=" + this.requiredTransactionId + '}';
    }

    public static class Decoder
    extends ByteToMessageDecoder {
        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            GetStoreFileRequest getStoreFileRequest = new StoreFileRequestMarshall().unmarshal0((ReadableChannel)new NetworkReadableClosableChannelNetty4(in));
            out.add(getStoreFileRequest);
        }
    }

    public static class Encoder
    extends MessageToByteEncoder<GetStoreFileRequest> {
        protected void encode(ChannelHandlerContext ctx, GetStoreFileRequest msg, ByteBuf out) throws Exception {
            new StoreFileRequestMarshall().marshal(msg, (WritableChannel)new NetworkFlushableByteBuf(out));
        }
    }

    static class StoreFileRequestMarshall
    extends SafeChannelMarshal<GetStoreFileRequest> {
        StoreFileRequestMarshall() {
        }

        @Override
        protected GetStoreFileRequest unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            StoreId storeId = (StoreId)StoreIdMarshal.INSTANCE.unmarshal(channel);
            long requiredTransactionId = channel.getLong();
            int fileNameLength = channel.getInt();
            byte[] fileNameBytes = new byte[fileNameLength];
            channel.get(fileNameBytes, fileNameLength);
            return new GetStoreFileRequest(storeId, new File(UTF8.decode((byte[])fileNameBytes)), requiredTransactionId);
        }

        @Override
        public void marshal(GetStoreFileRequest getStoreFileRequest, WritableChannel channel) throws IOException {
            StoreIdMarshal.INSTANCE.marshal(getStoreFileRequest.expectedStoreId(), channel);
            channel.putLong(getStoreFileRequest.requiredTransactionId());
            String name = getStoreFileRequest.file().getName();
            channel.putInt(name.length());
            channel.put(UTF8.encode((String)name), name.length());
        }
    }
}

