/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.CloseablesListener;
import org.neo4j.causalclustering.catchup.storecopy.DataSourceChecks;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyFiles;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyFilesProvider;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamingProtocol;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;

public class PrepareStoreCopyRequestHandler
extends SimpleChannelInboundHandler<PrepareStoreCopyRequest> {
    private final CatchupServerProtocol protocol;
    private final Supplier<CheckPointer> checkPointerSupplier;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final PrepareStoreCopyFilesProvider prepareStoreCopyFilesProvider;
    private final Supplier<NeoStoreDataSource> dataSourceSupplier;
    private final StoreFileStreamingProtocol streamingProtocol = new StoreFileStreamingProtocol();

    public PrepareStoreCopyRequestHandler(CatchupServerProtocol catchupServerProtocol, Supplier<CheckPointer> checkPointerSupplier, StoreCopyCheckPointMutex storeCopyCheckPointMutex, Supplier<NeoStoreDataSource> dataSourceSupplier, PrepareStoreCopyFilesProvider prepareStoreCopyFilesProvider) {
        this.protocol = catchupServerProtocol;
        this.checkPointerSupplier = checkPointerSupplier;
        this.storeCopyCheckPointMutex = storeCopyCheckPointMutex;
        this.prepareStoreCopyFilesProvider = prepareStoreCopyFilesProvider;
        this.dataSourceSupplier = dataSourceSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, PrepareStoreCopyRequest prepareStoreCopyRequest) throws IOException {
        CloseablesListener closeablesListener = new CloseablesListener();
        PrepareStoreCopyResponse response = PrepareStoreCopyResponse.error(PrepareStoreCopyResponse.Status.E_LISTING_STORE);
        try {
            NeoStoreDataSource neoStoreDataSource = this.dataSourceSupplier.get();
            if (!DataSourceChecks.hasSameStoreId(prepareStoreCopyRequest.getStoreId(), neoStoreDataSource)) {
                channelHandlerContext.write((Object)ResponseMessageType.PREPARE_STORE_COPY_RESPONSE);
                response = PrepareStoreCopyResponse.error(PrepareStoreCopyResponse.Status.E_STORE_ID_MISMATCH);
            } else {
                StoreResource[] nonReplayable;
                CheckPointer checkPointer = this.checkPointerSupplier.get();
                closeablesListener.add(this.tryCheckpointAndAcquireMutex(checkPointer));
                PrepareStoreCopyFiles prepareStoreCopyFiles = closeablesListener.add(this.prepareStoreCopyFilesProvider.prepareStoreCopyFiles(neoStoreDataSource));
                for (StoreResource storeResource : nonReplayable = prepareStoreCopyFiles.getAtomicFilesSnapshot()) {
                    this.streamingProtocol.stream(channelHandlerContext, storeResource);
                }
                channelHandlerContext.write((Object)ResponseMessageType.PREPARE_STORE_COPY_RESPONSE);
                response = this.createSuccessfulResponse(checkPointer, prepareStoreCopyFiles);
            }
        }
        finally {
            channelHandlerContext.writeAndFlush((Object)response).addListener((GenericFutureListener)closeablesListener);
            this.protocol.expect(CatchupServerProtocol.State.MESSAGE_TYPE);
        }
    }

    private PrepareStoreCopyResponse createSuccessfulResponse(CheckPointer checkPointer, PrepareStoreCopyFiles prepareStoreCopyFiles) throws IOException {
        LongSet indexIds = prepareStoreCopyFiles.getNonAtomicIndexIds();
        File[] files = prepareStoreCopyFiles.listReplayableFiles();
        long lastCommittedTxId = checkPointer.lastCheckPointedTransactionId();
        return PrepareStoreCopyResponse.success(files, indexIds, lastCommittedTxId);
    }

    private Resource tryCheckpointAndAcquireMutex(CheckPointer checkPointer) throws IOException {
        return this.storeCopyCheckPointMutex.storeCopy(() -> checkPointer.tryCheckPoint((TriggerInfo)new SimpleTriggerInfo("Store copy")));
    }
}

