/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.ComposableMessageHandler;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterBindingHandler
implements LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> {
    private final LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> delegateHandler;
    private volatile ClusterId boundClusterId;
    private final Log log;

    public ClusterBindingHandler(LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> delegateHandler, LogProvider logProvider) {
        this.delegateHandler = delegateHandler;
        this.log = logProvider.getLog(this.getClass());
    }

    public static ComposableMessageHandler composable(LogProvider logProvider) {
        return delegate -> new ClusterBindingHandler(delegate, logProvider);
    }

    @Override
    public void start(ClusterId clusterId) throws Throwable {
        this.boundClusterId = clusterId;
        this.delegateHandler.start(clusterId);
    }

    @Override
    public void stop() throws Throwable {
        this.boundClusterId = null;
        this.delegateHandler.stop();
    }

    @Override
    public void handle(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> message) {
        if (Objects.isNull(this.boundClusterId)) {
            this.log.debug("Message handling has been stopped, dropping the message: %s", new Object[]{message.message()});
        } else if (!Objects.equals(this.boundClusterId, message.clusterId())) {
            this.log.info("Discarding message[%s] owing to mismatched clusterId. Expected: %s, Encountered: %s", new Object[]{message.message(), this.boundClusterId, message.clusterId()});
        } else {
            this.delegateHandler.handle(message);
        }
    }
}

