/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.SocketAddressParser;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;

class TransactionBackupServiceAddressResolver {
    TransactionBackupServiceAddressResolver() {
    }

    ListenSocketAddress backupAddressForTxProtocol(Config config) {
        String settingName = OnlineBackupSettings.online_backup_server.name();
        HostnamePort resolvedValueFromConfig = this.resolved(config);
        String modifiedLiteralValueToAvoidRange = String.format("%s:%d", resolvedValueFromConfig.getHost(), resolvedValueFromConfig.getPort());
        String defaultHostname = resolvedValueFromConfig.getHost();
        AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)SocketAddressParser.deriveSocketAddress((String)settingName, (String)modifiedLiteralValueToAvoidRange, (String)defaultHostname, (int)resolvedValueFromConfig.getPort(), AdvertisedSocketAddress::new);
        return new ListenSocketAddress(advertisedSocketAddress.getHostname(), advertisedSocketAddress.getPort());
    }

    private HostnamePort resolved(Config config) {
        int defaultPort = ((HostnamePort)Config.defaults().get(OnlineBackupSettings.online_backup_server)).getPort();
        HostnamePort resolved = (HostnamePort)config.get(OnlineBackupSettings.online_backup_server);
        if (resolved.getPort() == 0) {
            resolved = new HostnamePort(resolved.getHost(), defaultPort);
        }
        return resolved;
    }
}

