/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.neo4j.causalclustering.core.consensus.RaftMessageProcessingMonitor;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.ComposableMessageHandler;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.kernel.monitoring.Monitors;

public class RaftMessageMonitoringHandler
implements LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> {
    private final LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> raftMessageHandler;
    private final Clock clock;
    private final RaftMessageProcessingMonitor raftMessageDelayMonitor;

    public RaftMessageMonitoringHandler(LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> raftMessageHandler, Clock clock, Monitors monitors) {
        this.raftMessageHandler = raftMessageHandler;
        this.clock = clock;
        this.raftMessageDelayMonitor = (RaftMessageProcessingMonitor)monitors.newMonitor(RaftMessageProcessingMonitor.class, new String[0]);
    }

    public static ComposableMessageHandler composable(Clock clock, Monitors monitors) {
        return delegate -> new RaftMessageMonitoringHandler(delegate, clock, monitors);
    }

    @Override
    public synchronized void handle(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> incomingMessage) {
        Instant start = this.clock.instant();
        this.logDelay(incomingMessage, start);
        this.timeHandle(incomingMessage, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeHandle(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> incomingMessage, Instant start) {
        try {
            this.raftMessageHandler.handle(incomingMessage);
        }
        finally {
            Duration duration = Duration.between(start, this.clock.instant());
            this.raftMessageDelayMonitor.updateTimer(incomingMessage.type(), duration);
        }
    }

    private void logDelay(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> incomingMessage, Instant start) {
        Duration delay = Duration.between(incomingMessage.receivedAt(), start);
        this.raftMessageDelayMonitor.setDelay(delay);
    }

    @Override
    public void start(ClusterId clusterId) throws Throwable {
        this.raftMessageHandler.start(clusterId);
    }

    @Override
    public void stop() throws Throwable {
        this.raftMessageHandler.stop();
    }
}

