/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

@ChannelHandler.Sharable
public class RaftMessageNettyHandler
extends SimpleChannelInboundHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>>
implements Inbound<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> {
    private Inbound.MessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> actual;
    private Log log;

    public RaftMessageNettyHandler(LogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void registerHandler(Inbound.MessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> actual) {
        this.actual = actual;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, RaftMessages.ReceivedInstantClusterIdAwareMessage<?> incomingMessage) {
        try {
            this.actual.handle(incomingMessage);
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to process message %s", incomingMessage), (Throwable)e);
        }
    }
}

