/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.cache;

import java.util.Arrays;

public class CircularBuffer<V> {
    private final int arraySize;
    private Object[] elementArr;
    private int S;
    private int E;

    CircularBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be > 0.");
        }
        this.arraySize = capacity + 1;
        this.elementArr = new Object[this.arraySize];
    }

    public void clear(V[] evictions) {
        if (evictions.length != this.arraySize - 1) {
            throw new IllegalArgumentException("The eviction array must be of the same size as the capacity of the circular buffer.");
        }
        int i = 0;
        while (this.S != this.E) {
            evictions[i++] = this.elementArr[this.S];
            this.S = this.pos(this.S, 1);
        }
        this.S = 0;
        this.E = 0;
        Arrays.fill(this.elementArr, null);
    }

    private int pos(int base, int delta) {
        return Math.floorMod(base + delta, this.arraySize);
    }

    public V append(V e) {
        this.elementArr[this.E] = e;
        this.E = this.pos(this.E, 1);
        if (this.E == this.S) {
            Object old = this.elementArr[this.E];
            this.elementArr[this.E] = null;
            this.S = this.pos(this.S, 1);
            return (V)old;
        }
        return null;
    }

    public V read(int idx) {
        return (V)this.elementArr[this.pos(this.S, idx)];
    }

    public V remove() {
        if (this.S == this.E) {
            return null;
        }
        Object e = this.elementArr[this.S];
        this.elementArr[this.S] = null;
        this.S = this.pos(this.S, 1);
        return (V)e;
    }

    public V removeHead() {
        if (this.S == this.E) {
            return null;
        }
        this.E = this.pos(this.E, -1);
        Object e = this.elementArr[this.E];
        this.elementArr[this.E] = null;
        return (V)e;
    }

    public int size() {
        return Math.floorMod(this.E - this.S, this.arraySize);
    }
}

