/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.log.EntryRecord;
import org.neo4j.causalclustering.core.consensus.log.LogPosition;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.EntryRecordCursor;
import org.neo4j.causalclustering.core.consensus.log.segmented.PositionCache;
import org.neo4j.causalclustering.core.consensus.log.segmented.Reader;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReferenceCounter;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.cursor.IOCursor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.WritableChannel;

class SegmentFile
implements AutoCloseable {
    private static final SegmentHeader.Marshal headerMarshal = new SegmentHeader.Marshal();
    private final Log log;
    private final FileSystemAbstraction fileSystem;
    private final File file;
    private final ReaderPool readerPool;
    private final ChannelMarshal<ReplicatedContent> contentMarshal;
    private final PositionCache positionCache;
    private final ReferenceCounter refCount;
    private final SegmentHeader header;
    private final long version;
    private PhysicalFlushableChannel bufferedWriter;

    SegmentFile(FileSystemAbstraction fileSystem, File file, ReaderPool readerPool, long version, ChannelMarshal<ReplicatedContent> contentMarshal, LogProvider logProvider, SegmentHeader header) {
        this.fileSystem = fileSystem;
        this.file = file;
        this.readerPool = readerPool;
        this.contentMarshal = contentMarshal;
        this.header = header;
        this.version = version;
        this.positionCache = new PositionCache();
        this.refCount = new ReferenceCounter();
        this.log = logProvider.getLog(this.getClass());
    }

    static SegmentFile create(FileSystemAbstraction fileSystem, File file, ReaderPool readerPool, long version, ChannelMarshal<ReplicatedContent> contentMarshal, LogProvider logProvider, SegmentHeader header) throws IOException {
        if (fileSystem.fileExists(file)) {
            throw new IllegalStateException("File was not expected to exist");
        }
        SegmentFile segment = new SegmentFile(fileSystem, file, readerPool, version, contentMarshal, logProvider, header);
        headerMarshal.marshal(header, (WritableChannel)segment.getOrCreateWriter());
        segment.flush();
        return segment;
    }

    IOCursor<EntryRecord> getCursor(long logIndex) throws IOException, DisposedException {
        assert (logIndex > this.header.prevIndex());
        if (!this.refCount.increase()) {
            throw new DisposedException();
        }
        long offsetIndex = logIndex - (this.header.prevIndex() + 1L);
        LogPosition position = this.positionCache.lookup(offsetIndex);
        Reader reader = this.readerPool.acquire(this.version, position.byteOffset);
        try {
            long currentIndex = position.logIndex;
            return new EntryRecordCursor(reader, this.contentMarshal, currentIndex, offsetIndex, this);
        }
        catch (EndOfStreamException e) {
            this.readerPool.release(reader);
            this.refCount.decrease();
            return IOCursor.getEmpty();
        }
        catch (IOException e) {
            reader.close();
            this.refCount.decrease();
            throw e;
        }
    }

    private synchronized PhysicalFlushableChannel getOrCreateWriter() throws IOException {
        if (this.bufferedWriter == null) {
            if (!this.refCount.increase()) {
                throw new IOException("Writer has been closed");
            }
            StoreChannel channel = this.fileSystem.open(this.file, OpenMode.READ_WRITE);
            channel.position(channel.size());
            this.bufferedWriter = new PhysicalFlushableChannel(channel);
        }
        return this.bufferedWriter;
    }

    synchronized long position() throws IOException {
        return this.getOrCreateWriter().position();
    }

    synchronized void closeWriter() {
        if (this.bufferedWriter != null) {
            try {
                this.flush();
                this.bufferedWriter.close();
            }
            catch (IOException e) {
                this.log.error("Failed to close writer for: " + this.file, (Throwable)e);
            }
            this.bufferedWriter = null;
            this.refCount.decrease();
        }
    }

    public synchronized void write(long logIndex, RaftLogEntry entry) throws IOException {
        EntryRecord.write((WritableChannel)this.getOrCreateWriter(), this.contentMarshal, logIndex, entry.term(), entry.content());
    }

    synchronized void flush() throws IOException {
        this.bufferedWriter.prepareForFlush().flush();
    }

    public boolean delete() {
        return this.fileSystem.deleteFile(this.file);
    }

    public SegmentHeader header() {
        return this.header;
    }

    public long size() {
        return this.fileSystem.getFileSize(this.file);
    }

    String getFilename() {
        return this.file.getName();
    }

    boolean tryClose() {
        if (this.refCount.tryDispose()) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.closeWriter();
        this.readerPool.prune(this.version);
        if (!this.refCount.tryDispose()) {
            throw new IllegalStateException(String.format("Segment still referenced. Value: %d", this.refCount.get()));
        }
    }

    public String toString() {
        return "SegmentFile{file=" + this.file.getName() + ", header=" + this.header + '}';
    }

    ReferenceCounter refCount() {
        return this.refCount;
    }

    PositionCache positionCache() {
        return this.positionCache;
    }

    public ReaderPool readerPool() {
        return this.readerPool;
    }
}

