/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

class SegmentHeader {
    static final int SIZE = 32;
    private final long prevFileLastIndex;
    private final long version;
    private final long prevIndex;
    private final long prevTerm;

    SegmentHeader(long prevFileLastIndex, long version, long prevIndex, long prevTerm) {
        this.prevFileLastIndex = prevFileLastIndex;
        this.version = version;
        this.prevIndex = prevIndex;
        this.prevTerm = prevTerm;
    }

    long prevFileLastIndex() {
        return this.prevFileLastIndex;
    }

    public long version() {
        return this.version;
    }

    public long prevIndex() {
        return this.prevIndex;
    }

    public long prevTerm() {
        return this.prevTerm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentHeader that = (SegmentHeader)o;
        return this.prevFileLastIndex == that.prevFileLastIndex && this.version == that.version && this.prevIndex == that.prevIndex && this.prevTerm == that.prevTerm;
    }

    public int hashCode() {
        return Objects.hash(this.prevFileLastIndex, this.version, this.prevIndex, this.prevTerm);
    }

    public String toString() {
        return "SegmentHeader{prevFileLastIndex=" + this.prevFileLastIndex + ", version=" + this.version + ", prevIndex=" + this.prevIndex + ", prevTerm=" + this.prevTerm + '}';
    }

    static class Marshal
    extends SafeChannelMarshal<SegmentHeader> {
        Marshal() {
        }

        @Override
        public void marshal(SegmentHeader header, WritableChannel channel) throws IOException {
            channel.putLong(header.prevFileLastIndex);
            channel.putLong(header.version);
            channel.putLong(header.prevIndex);
            channel.putLong(header.prevTerm);
        }

        @Override
        public SegmentHeader unmarshal0(ReadableChannel channel) throws IOException {
            long prevFileLastIndex = channel.getLong();
            long version = channel.getLong();
            long prevIndex = channel.getLong();
            long prevTerm = channel.getLong();
            return new SegmentHeader(prevFileLastIndex, version, prevIndex, prevTerm);
        }
    }
}

