/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class MembershipEntry {
    private long logIndex;
    private Set<MemberId> members;

    public MembershipEntry(long logIndex, Set<MemberId> members) {
        this.members = members;
        this.logIndex = logIndex;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public Set<MemberId> members() {
        return this.members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MembershipEntry that = (MembershipEntry)o;
        return this.logIndex == that.logIndex && Objects.equals(this.members, that.members);
    }

    public int hashCode() {
        return Objects.hash(this.logIndex, this.members);
    }

    public String toString() {
        return "MembershipEntry{logIndex=" + this.logIndex + ", members=" + this.members + '}';
    }

    public static class Marshal
    extends SafeStateMarshal<MembershipEntry> {
        MemberId.Marshal memberMarshal = new MemberId.Marshal();

        @Override
        public MembershipEntry startState() {
            return null;
        }

        @Override
        public long ordinal(MembershipEntry entry) {
            return entry.logIndex;
        }

        @Override
        public void marshal(MembershipEntry entry, WritableChannel channel) throws IOException {
            if (entry == null) {
                channel.putInt(0);
                return;
            }
            channel.putInt(1);
            channel.putLong(entry.logIndex);
            channel.putInt(entry.members.size());
            for (MemberId member : entry.members) {
                this.memberMarshal.marshal(member, channel);
            }
        }

        @Override
        protected MembershipEntry unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            int hasEntry = channel.getInt();
            if (hasEntry == 0) {
                return null;
            }
            long logIndex = channel.getLong();
            int memberCount = channel.getInt();
            HashSet<MemberId> members = new HashSet<MemberId>();
            for (int i = 0; i < memberCount; ++i) {
                members.add((MemberId)this.memberMarshal.unmarshal(channel));
            }
            return new MembershipEntry(logIndex, members);
        }
    }
}

