/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Progress {
    private final Semaphore replicationSignal = new Semaphore(0);
    private final CompletableFuture<Object> futureResult = new CompletableFuture();
    private volatile boolean isReplicated;

    public void triggerReplicationEvent() {
        this.replicationSignal.release();
    }

    public void setReplicated() {
        this.isReplicated = true;
        this.replicationSignal.release();
    }

    public void awaitReplication(long timeoutMillis) throws InterruptedException {
        if (!this.isReplicated) {
            this.replicationSignal.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isReplicated() {
        return this.isReplicated;
    }

    public CompletableFuture<Object> futureResult() {
        return this.futureResult;
    }
}

