/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.core.consensus.LeaderListener;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.Progress;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.replication.Throttler;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.replication.session.OperationContext;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftReplicator
extends LifecycleAdapter
implements Replicator,
LeaderListener {
    private final MemberId me;
    private final Outbound<MemberId, RaftMessages.RaftMessage> outbound;
    private final ProgressTracker progressTracker;
    private final LocalSessionPool sessionPool;
    private final TimeoutStrategy progressTimeoutStrategy;
    private final AvailabilityGuard availabilityGuard;
    private final LeaderLocator leaderLocator;
    private final TimeoutStrategy leaderTimeoutStrategy;
    private final Log log;
    private final Throttler throttler;

    public RaftReplicator(LeaderLocator leaderLocator, MemberId me, Outbound<MemberId, RaftMessages.RaftMessage> outbound, LocalSessionPool sessionPool, ProgressTracker progressTracker, TimeoutStrategy progressTimeoutStrategy, TimeoutStrategy leaderTimeoutStrategy, AvailabilityGuard availabilityGuard, LogProvider logProvider, long replicationLimit) {
        this.me = me;
        this.outbound = outbound;
        this.progressTracker = progressTracker;
        this.sessionPool = sessionPool;
        this.progressTimeoutStrategy = progressTimeoutStrategy;
        this.leaderTimeoutStrategy = leaderTimeoutStrategy;
        this.availabilityGuard = availabilityGuard;
        this.throttler = new Throttler(replicationLimit);
        this.leaderLocator = leaderLocator;
        leaderLocator.registerListener(this);
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public Future<Object> replicate(ReplicatedContent command, boolean trackResult) throws InterruptedException {
        if (command.hasSize()) {
            return (Future)this.throttler.invoke(() -> this.replicate0(command, trackResult), command.size());
        }
        return this.replicate0(command, trackResult);
    }

    private Future<Object> replicate0(ReplicatedContent command, boolean trackResult) throws InterruptedException {
        OperationContext session = this.sessionPool.acquireSession();
        DistributedOperation operation = new DistributedOperation(command, session.globalSession(), session.localOperationId());
        Progress progress = this.progressTracker.start(operation);
        TimeoutStrategy.Timeout progressTimeout = this.progressTimeoutStrategy.newTimeout();
        TimeoutStrategy.Timeout leaderTimeout = this.leaderTimeoutStrategy.newTimeout();
        do {
            this.assertDatabaseNotShutdown();
            try {
                this.outbound.send(this.leaderLocator.getLeader(), new RaftMessages.NewEntry.Request(this.me, operation), true);
                leaderTimeout = this.leaderTimeoutStrategy.newTimeout();
                progress.awaitReplication(progressTimeout.getMillis());
                progressTimeout.increment();
            }
            catch (InterruptedException e) {
                this.progressTracker.abort(operation);
                throw e;
            }
            catch (NoLeaderFoundException e) {
                this.log.debug("Could not replicate operation " + operation + " because no leader was found. Retrying.", (Throwable)e);
                Thread.sleep(leaderTimeout.getMillis());
                leaderTimeout.increment();
            }
        } while (!progress.isReplicated());
        BiConsumer<Object, Throwable> cleanup = (ignored1, ignored2) -> this.sessionPool.releaseSession(session);
        if (trackResult) {
            progress.futureResult().whenComplete((BiConsumer)cleanup);
        } else {
            cleanup.accept(null, null);
        }
        return progress.futureResult();
    }

    @Override
    public void onLeaderSwitch(LeaderInfo leaderInfo) {
        this.progressTracker.triggerReplicationEvent();
    }

    private void assertDatabaseNotShutdown() {
        if (this.availabilityGuard.isShutdown()) {
            throw new DatabaseShutdownException("Database has been shutdown, transaction cannot be replicated.");
        }
    }
}

