/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.Optional;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CoreSnapshotService;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloaderService;
import org.neo4j.causalclustering.identity.BoundState;
import org.neo4j.causalclustering.identity.ClusterBinder;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.kernel.lifecycle.SafeLifecycle;
import org.neo4j.scheduler.JobScheduler;

public class CoreLife
extends SafeLifecycle {
    private final RaftMachine raftMachine;
    private final LocalDatabase localDatabase;
    private final ClusterBinder clusterBinder;
    private final CommandApplicationProcess applicationProcess;
    private final CoreStateMachines coreStateMachines;
    private final LifecycleMessageHandler<?> raftMessageHandler;
    private final CoreSnapshotService snapshotService;
    private final CoreStateDownloaderService downloadService;

    public CoreLife(RaftMachine raftMachine, LocalDatabase localDatabase, ClusterBinder clusterBinder, CommandApplicationProcess commandApplicationProcess, CoreStateMachines coreStateMachines, LifecycleMessageHandler<?> raftMessageHandler, CoreSnapshotService snapshotService, CoreStateDownloaderService downloadService) {
        this.raftMachine = raftMachine;
        this.localDatabase = localDatabase;
        this.clusterBinder = clusterBinder;
        this.applicationProcess = commandApplicationProcess;
        this.coreStateMachines = coreStateMachines;
        this.raftMessageHandler = raftMessageHandler;
        this.snapshotService = snapshotService;
        this.downloadService = downloadService;
    }

    public void init0() throws Throwable {
        this.localDatabase.init();
    }

    public void start0() throws Throwable {
        BoundState boundState = this.clusterBinder.bindToCluster();
        this.raftMessageHandler.start(boundState.clusterId());
        boolean startedByDownloader = false;
        if (boundState.snapshot().isPresent()) {
            CoreSnapshot snapshot = boundState.snapshot().get();
            this.snapshotService.installSnapshot(snapshot);
        } else {
            this.snapshotService.awaitState();
            Optional<JobScheduler.JobHandle> downloadJob = this.downloadService.downloadJob();
            if (downloadJob.isPresent()) {
                downloadJob.get().waitTermination();
                startedByDownloader = true;
            }
        }
        if (!startedByDownloader) {
            this.localDatabase.start();
            this.coreStateMachines.installCommitProcess(this.localDatabase.getCommitProcess());
        }
        this.applicationProcess.start();
        this.raftMachine.postRecoveryActions();
    }

    public void stop0() throws Throwable {
        this.raftMachine.stopTimers();
        this.raftMessageHandler.stop();
        this.applicationProcess.stop();
        this.localDatabase.stop();
    }

    public void shutdown0() throws Throwable {
        this.localDatabase.shutdown();
    }
}

