/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.concurrent.CompletableFuture;

public class Result {
    private final Exception exception;
    private final Object result;

    private Result(Exception exception) {
        this.exception = exception;
        this.result = null;
    }

    private Result(Object result) {
        this.result = result;
        this.exception = null;
    }

    public static Result of(Object result) {
        return new Result(result);
    }

    public static Result of(Exception exception) {
        return new Result(exception);
    }

    public Object consume() throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    public CompletableFuture<Object> apply(CompletableFuture<Object> future) {
        if (this.exception != null) {
            future.completeExceptionally(this.exception);
        } else {
            future.complete(this.result);
        }
        return future;
    }

    public String toString() {
        return "Result{exception=" + this.exception + ", result=" + this.result + '}';
    }
}

