/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.locks;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.locks.LockToken;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LeaderOnlyLockManager
implements Locks {
    public static final String LOCK_NOT_ON_LEADER_ERROR_MESSAGE = "Should only attempt to take locks when leader.";
    private final MemberId myself;
    private final Replicator replicator;
    private final LeaderLocator leaderLocator;
    private final Locks localLocks;
    private final ReplicatedLockTokenStateMachine lockTokenStateMachine;

    public LeaderOnlyLockManager(MemberId myself, Replicator replicator, LeaderLocator leaderLocator, Locks localLocks, ReplicatedLockTokenStateMachine lockTokenStateMachine) {
        this.myself = myself;
        this.replicator = replicator;
        this.leaderLocator = leaderLocator;
        this.localLocks = localLocks;
        this.lockTokenStateMachine = lockTokenStateMachine;
    }

    public Locks.Client newClient() {
        return new LeaderOnlyLockClient(this.localLocks.newClient());
    }

    private synchronized int acquireTokenOrThrow() {
        Future<Object> future;
        ReplicatedLockTokenRequest currentToken = this.lockTokenStateMachine.currentToken();
        if (this.myself.equals(currentToken.owner())) {
            return currentToken.id();
        }
        this.ensureLeader();
        ReplicatedLockTokenRequest lockTokenRequest = new ReplicatedLockTokenRequest(this.myself, LockToken.nextCandidateId(currentToken.id()));
        try {
            future = this.replicator.replicate(lockTokenRequest, true);
        }
        catch (InterruptedException e) {
            throw new AcquireLockTimeoutException((Throwable)e, "Interrupted acquiring token.", (Status)Status.Transaction.Interrupted);
        }
        try {
            boolean success = (Boolean)future.get();
            if (success) {
                return lockTokenRequest.id();
            }
            throw new AcquireLockTimeoutException("Failed to acquire lock token. Was taken by another candidate.", (Status)Status.Cluster.NotALeader);
        }
        catch (ExecutionException e) {
            throw new AcquireLockTimeoutException((Throwable)e, "Failed to acquire lock token.", (Status)Status.Cluster.NotALeader);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AcquireLockTimeoutException((Throwable)e, "Failed to acquire lock token.", (Status)Status.Transaction.Interrupted);
        }
    }

    private void ensureLeader() {
        MemberId leader;
        try {
            leader = this.leaderLocator.getLeader();
        }
        catch (NoLeaderFoundException e) {
            throw new AcquireLockTimeoutException((Throwable)e, "Could not acquire lock token.", (Status)Status.Cluster.NoLeaderAvailable);
        }
        if (!leader.equals(this.myself)) {
            throw new AcquireLockTimeoutException(LOCK_NOT_ON_LEADER_ERROR_MESSAGE, (Status)Status.Cluster.NotALeader);
        }
    }

    public void accept(Locks.Visitor visitor) {
        this.localLocks.accept(visitor);
    }

    public void close() {
        this.localLocks.close();
    }

    private class LeaderOnlyLockClient
    implements Locks.Client {
        private final Locks.Client localClient;
        private int lockTokenId = -1;

        LeaderOnlyLockClient(Locks.Client localClient) {
            this.localClient = localClient;
        }

        private void ensureHoldingToken() {
            if (this.lockTokenId == -1) {
                this.lockTokenId = LeaderOnlyLockManager.this.acquireTokenOrThrow();
            } else if (this.lockTokenId != LeaderOnlyLockManager.this.lockTokenStateMachine.currentToken().id()) {
                throw new AcquireLockTimeoutException("Local instance lost lock token.", (Status)Status.Cluster.NotALeader);
            }
        }

        public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceId) throws AcquireLockTimeoutException {
            this.localClient.acquireShared(tracer, resourceType, resourceId);
        }

        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceId) throws AcquireLockTimeoutException {
            this.ensureHoldingToken();
            this.localClient.acquireExclusive(tracer, resourceType, resourceId);
        }

        public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
            this.ensureHoldingToken();
            return this.localClient.tryExclusiveLock(resourceType, resourceId);
        }

        public boolean trySharedLock(ResourceType resourceType, long resourceId) {
            return this.localClient.trySharedLock(resourceType, resourceId);
        }

        public boolean reEnterShared(ResourceType resourceType, long resourceId) {
            return this.localClient.reEnterShared(resourceType, resourceId);
        }

        public boolean reEnterExclusive(ResourceType resourceType, long resourceId) {
            this.ensureHoldingToken();
            return this.localClient.reEnterExclusive(resourceType, resourceId);
        }

        public void releaseShared(ResourceType resourceType, long ... resourceIds) {
            this.localClient.releaseShared(resourceType, resourceIds);
        }

        public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
            this.localClient.releaseExclusive(resourceType, resourceIds);
        }

        public void prepare() {
            this.localClient.prepare();
        }

        public void stop() {
            this.localClient.stop();
        }

        public void close() {
            this.localClient.close();
        }

        public int getLockSessionId() {
            return this.lockTokenId;
        }

        public Stream<? extends ActiveLock> activeLocks() {
            return this.localClient.activeLocks();
        }

        public long activeLockCount() {
            return this.localClient.activeLockCount();
        }
    }
}

