/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.locks;

import java.io.IOException;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ReplicatedLockTokenSerializer {
    private ReplicatedLockTokenSerializer() {
    }

    public static void marshal(ReplicatedLockTokenRequest tokenRequest, WritableChannel channel) throws IOException {
        channel.putInt(tokenRequest.id());
        new MemberId.Marshal().marshal(tokenRequest.owner(), channel);
    }

    public static ReplicatedLockTokenRequest unmarshal(ReadableChannel channel) throws IOException, EndOfStreamException {
        int candidateId = channel.getInt();
        MemberId owner = (MemberId)new MemberId.Marshal().unmarshal(channel);
        return new ReplicatedLockTokenRequest(owner, candidateId);
    }
}

